% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_selection.R
\name{fb_select}
\alias{fb_select}
\title{Free order model selection procedure}
\usage{
fb_select(
  data,
  age_name,
  score_name,
  family,
  selcrit = "BIC",
  spline = FALSE,
  method = "RS(10000)",
  max_poly = c(5, 5, 2, 2),
  min_poly = c(0, 0, 0, 0),
  start_poly = c(2, 1, 0, 0),
  trace = TRUE,
  seed = 123,
  parallel = FALSE
)
}
\arguments{
\item{data}{data.frame. Sample on which to fit the distribution; contains the scores and ages.}

\item{age_name}{string. Name of the age variable.}

\item{score_name}{string. Name of the score variable.}

\item{family}{string. For example, \code{"BB"}, \code{"BCPE"}, \code{"NO"}, etc.
See \link[gamlss.dist:gamlss.family]{gamlss.dist::gamlss.family} for more information.}

\item{selcrit}{string. Model selection criterion: \code{"AIC"}, \code{"BIC"} (default), \code{"GAIC(3)"}, or \code{"CV"}
(cross-validation with 10 folds).}

\item{spline}{logical. If \code{FALSE} (default), estimate polynomial(s) for \eqn{\mu};
if \code{TRUE}, estimate a p-spline for \eqn{\mu}.}

\item{method}{string. Estimation method for \code{\link[gamlss:gamlss]{gamlss::gamlss()}}. Either \code{"RS()"}, \code{"CG()"}, or \code{"mixed()"},
with iteration count. Default is \code{"RS(10000)"}.}

\item{max_poly}{vector. Maximum polynomial degrees for each parameter.}

\item{min_poly}{vector. Minimum polynomial degrees for each parameter.}

\item{start_poly}{vector. Starting polynomial degrees for each parameter.}

\item{trace}{logical. If \code{TRUE}, prints progress during selection.}

\item{seed}{integer. Random seed for cross-validation folds.}

\item{parallel}{logical. If \code{TRUE}, candidate models are evaluated in
parallel using \pkg{future.apply}. This can reduce elapsed time
for computationally heavy settings (e.g., large datasets, distributions
with many parameters, or when using cross-validation as the selection
criterion). For light models or small datasets, the overhead of
parallelization may make it slower than sequential evaluation.
Parallelization is not supported for user-defined distribution families;
use built-in \pkg{gamlss.dist} families instead. Default is \code{FALSE}.}
}
\value{
A selected GAMLSS model with the chosen polynomial degrees and the final criterion value.
}
\description{
\code{fb_select()} applies the free order model selection procedure, using forward–backward selection
\insertCite{voncken2019model}{normref}.
For a given GAMLSS distribution and model selection criterion, it selects the optimal
polynomial degrees for all distribution parameters.
}
\details{
If \code{parallel = TRUE}, candidate models are evaluated in parallel using the
\pkg{future} and \pkg{future.apply} packages. If these packages are not installed,
a message is printed and the function continues with sequential evaluation.
Parallelization can reduce elapsed time for large datasets, complex models and cross-validation,
but may be slower than sequential evaluation for smaller problems.
}
\examples{
\donttest{
invisible(data("ids_data"))
mydata <- shape_data(ids_data, age_name = "age", score_name = "y14", family = "BB")
mod <- fb_select(mydata, age_name = "age", score_name = "shaped_score",
                 family = "BB", selcrit = "BIC")
}

}
\references{
\insertRef{voncken2019model}{normref}
}
\seealso{
\code{\link[=shape_data]{shape_data()}}, \code{\link[=fb_select]{fb_select()}}, \code{\link[=normtable_create]{normtable_create()}}
}
