% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_fill.R
\name{nest_fill}
\alias{nest_fill}
\title{Fill missing values in a column of nested data frames}
\usage{
nest_fill(
  .data,
  .nest_data,
  ...,
  .direction = c("down", "up", "downup", "updown")
)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{...}{\code{<[`tidy-select`][tidyr_tidy_select]>} Columns to fill.}

\item{.direction}{Direction in which to fill missing values. Currently either
"down" (the default), "up", "downup" (i.e. first down and then up) or "updown"
(first up and then down).}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will have the chosen columns filled in the direction specified by \code{.direction}.
}
\description{
\code{nest_fill()} is used to fill missing values in selected columns of nested data
frames using the next or previous entries in a column of nested data frames.
}
\details{
\code{nest_fill()} is a wrapper for \code{[tidyr::fill()]} and maintains the functionality
of \code{fill()} within each nested data frame. For more information on \code{fill()}
please refer to the documentation in \href{https://tidyr.tidyverse.org/}{'tidyr'}.
}
\examples{
set.seed(123)
gm <-
  gapminder::gapminder \%>\%
  dplyr::mutate(pop = dplyr::if_else(runif(dplyr::n()) >= 0.9,
                                     NA_integer_,
                                     pop))

gm_nest <- gm \%>\% tidyr::nest(country_data = -continent)

gm_nest \%>\%
  nest_fill(country_data, pop, .direction = "down")
}
\seealso{
Other tidyr verbs: 
\code{\link{nest_drop_na}()},
\code{\link{nest_extract}()},
\code{\link{nest_replace_na}()},
\code{\link{nest_separate}()},
\code{\link{nest_unite}()}
}
\concept{tidyr verbs}
