% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_relocate.R
\name{nest_relocate}
\alias{nest_relocate}
\title{Change column order within a nested data frame}
\usage{
nest_relocate(.data, .nest_data, ..., .before = NULL, .after = NULL)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{...}{Columns to move.}

\item{.before, .after}{Destination of columns selected by \code{...}. Supplying
neither will move columns to the left-hand side; specifying both is an
error.}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will also be of the same type as the input. Each object in \code{.nest_data} has
the following properties:
\itemize{
\item Rows are not affected.
\item The same columns appear in the output, but (usually) in a different place.
\item Data frame attributes are preserved.
\item Groups are not affected.
}
}
\description{
\code{nest_relocate()} changes column positions within a nested data frame, using
the same syntax as \code{\link[=nest_select]{nest_select()}} or \code{\link[dplyr:select]{dplyr::select()}} to make it easy to
move blocks of columns at once.
}
\details{
\code{nest_relocate()} is largely a wrapper for \code{\link[dplyr:relocate]{dplyr::relocate()}} and maintains
the functionality of \code{relocate()} within each nested data frame. For more
information on \code{relocate()}, please refer to the documentation in
\href{https://dplyr.tidyverse.org/}{\code{dplyr}}.
}
\examples{
gm_nest <- gapminder::gapminder \%>\% tidyr::nest(country_data = -continent)

gm_nest \%>\% nest_relocate(country_data, year)
gm_nest \%>\% nest_relocate(country_data, pop, .after = year)
}
