% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nest_summarise.R
\name{nest_summarise}
\alias{nest_summarise}
\alias{nest_summarize}
\title{Summarise each group in nested data frames to fewer rows}
\usage{
nest_summarise(.data, .nest_data, ..., .groups = NULL)

nest_summarize(.data, .nest_data, ..., .groups = NULL)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g., a tibble), or a lazy
data frame (e.g., from dbplyr or dtplyr).}

\item{.nest_data}{A list-column containing data frames}

\item{...}{Name-value pairs of functions. The name will be the name of the
variable in the result.

The value can be:
\itemize{
\item A vector of length 1, e.g. \code{min(x)}, \code{n()}, or \code{sum(is.na(y))}.
\item A vector of length \code{n}, e.g., \code{quantile()}.
\item A data frame, to add multiple columns from a single expression.
}}

\item{.groups}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Grouping structure of the
result. Refer to \code{\link[dplyr:summarise]{dplyr::summarise()}} for more up-to-date information.}
}
\value{
An object of the same type as \code{.data}. Each object in the column \code{.nest_data}
will \emph{usually} be of the same type as the input. Each object in \code{.nest_data} has
the following properties:
\itemize{
\item The rows come from the underlying \href{https://dplyr.tidyverse.org/reference/group_data.html}{\code{group_keys()}}
\item The columns are a combination of the grouping keys and the summary
expressions that you provide.
\item The grouping structure is controlled by the \code{.groups} argument, the output
may be another grouped_df, a tibble, or a rowwise data frame.
\item Data frame attributes are \strong{not} preserved, because \code{nest_summarise()}
fundamentally creates a new data frame for each object in \code{.nest_data}.
}
}
\description{
\code{nest_summarise()} creates a new set of nested data frames. Each will have
one (or more) rows for each combination of grouping variables; if there are
no grouping variables, the output will have a single row summarising all
observations in \code{.nest_data}. Each nested data frame will contain one column
for each grouping variable and one column for each of the summary statistics
that you have specified.

\code{nest_summarise()} and \code{nest_summarize()} are synonyms.
}
\details{
\code{nest_summarise()} is largely a wrapper for \code{\link[dplyr:summarise]{dplyr::summarise()}} and
maintains the functionality of \code{summarise()} within each nested data frame.
For more information on \code{summarise()}, please refer to the documentation in
\href{https://dplyr.tidyverse.org/}{\code{dplyr}}.
}
\examples{
gm_nest <- gapminder::gapminder \%>\% tidyr::nest(country_data = -continent)

# a summary applied to an ungrouped tbl returns a single row
gm_nest \%>\%
  nest_summarise(
    country_data,
    n = dplyr::n(),
    median_pop = median(pop)
  )

# usually, you'll want to group first
gm_nest \%>\%
  nest_group_by(country_data, country) \%>\%
  nest_summarise(
    country_data,
    n = dplyr::n(),
    median_pop = median(pop)
  )
}
\seealso{
Other single table verbs: 
\code{\link{nest_arrange}()},
\code{\link{nest_filter}()},
\code{\link{nest_mutate}()},
\code{\link{nest_rename}()},
\code{\link{nest_select}()},
\code{\link{nest_slice}()}
}
\concept{single table verbs}
