% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{australia}
\alias{australia}
\alias{states}
\title{Geospatial data of the Australian state and territory administrative boundaries.}
\format{
An object of class \code{sfc_MULTIPOLYGON} (inherits from \code{sfc}) of length 1.

An object of class \code{sf} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 8 rows and 9 columns.
}
\source{
Australian Bureau of Statistics. "Australian Statistical Geography Standard (ASGS) Edition 3." ABS, Jul2021-Jun2026,
\url{https://www.abs.gov.au/statistics/standards/australian-statistical-geography-standard-asgs-edition-3/jul2021-jun2026}, accessed 10 November 2022.

The original dataset is published under the \href{https://creativecommons.org/licenses/by/4.0/}{Creative Commons Attribution 4.0 International} licence, © Commonwealth of Australia 2021.
}
\usage{
australia

states
}
\description{
Excludes external territories.
}
\details{
The geometries have been simplified with a tolerance of 5 km to reduce the
level of detail.
}
\section{Functions}{
\itemize{
\item \code{australia}: External boundaries of Australia as a multipolygon.

\item \code{states}: State and internal territory boundaries of Australia.

}}
\examples{
library(ggplot2)
ggplot(states) + geom_sf(aes(fill = STE_NAME21))
}
\keyword{datasets}
