% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-permute.r
\name{null_permute}
\alias{null_permute}
\title{Generate null data by permuting a variable.}
\usage{
null_permute(var)
}
\arguments{
\item{var}{name of variable to permute}
}
\value{
a function that given \code{data} generates a null data set.
For use with \code{\link{lineup}} or \code{\link{rorschach}}
}
\description{
Null hypothesis: variable is independent of others
}
\examples{
data(mtcars)
library(ggplot2)
ggplot(data=rorschach(method=null_permute("mpg"), n = 3, true=mtcars)) +
geom_boxplot(aes(x=factor(cyl), y=mpg, fill=factor(cyl))) +facet_grid(.~.sample) +
theme(legend.position="none", aspect.ratio=1)
}
\seealso{
null_lm, null_dist
}
