% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appendLabels.R
\name{appendLabels}
\alias{appendLabels}
\title{Appends labels of annotations on given layers to a dataframe of matches.}
\usage{
appendLabels(
  matches,
  layer.ids,
  target.offset = 0,
  annotations.per.layer = 1,
  page.length = 1000,
  no.progress = FALSE,
  labbcat.url = NULL,
  column.prefix = NULL
)
}
\arguments{
\item{matches}{A dataframe returned by \link{getMatches} or \link{getAllUtterances}, identifying
the results to which annotation labels should be appended.}

\item{layer.ids}{A vector of layer IDs.}

\item{target.offset}{The distance from the original target of the match, e.g.
\itemize{
\item \emph{0} -- find annotations of the match target itself
\item \emph{1} -- find annotations of the token immediately \emph{after} match target
\item \emph{-1} -- find annotations of the token immediately \emph{before} match target
}}

\item{annotations.per.layer}{The number of annotations on the given layer to
retrieve. In most cases, there's only one annotation available. However, tokens
may, for example, be annotated with `all possible phonemic transcriptions', in which
case using a value of greater than 1 for this parameter provides other phonemic
transcriptions, for tokens that have more than one.}

\item{page.length}{In order to prevent timeouts when there are a large number of
matches or the network connection is slow, rather than retrieving matches in one
big request, they are retrieved using many smaller requests. This parameter
controls the number of results retrieved per request.}

\item{no.progress}{TRUE to suppress visual progress bar. Otherwise, progress bar will be
shown when interactive().}

\item{labbcat.url}{URL to the LaBB-CAT instance (instead of inferring it from \code{matches}).}

\item{column.prefix}{A string to prefix each new column name with.}
}
\value{
\code{matches} with the labels appended as new columns.
}
\description{
This is a version of \link{getMatchLabels} that can have a dataframe of matches piped into
it, and returns the dataframe with columns appended.
}
\examples{
\dontrun{
## Perform a search
results <- getMatches(labbcat.url, list(orthography="quake")) |>    
   appendLabels("topic") ## Get the topic annotations for the matches
}

}
\seealso{
\itemize{
\item \link{getMatchLabels}
\item \link{getMatches}
}
}
\keyword{annotation}
\keyword{label}
\keyword{layer}
