% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_Ri.R
\name{get_Ri}
\alias{get_Ri}
\title{Compute case reproduction numbers (Ri) from outbreaker2 chains}
\usage{
get_Ri(out)
}
\arguments{
\item{out}{An object of class \code{outbreaker_chains}}
}
\value{
A data frame where:
\itemize{
\item Each row represents an MCMC iteration
\item Each column represents an individual (named by their identifier)
\item Values represent the reproduction number (Ri) for that individual
in that iteration
}
}
\description{
This function computes the number of secondary infections caused by each
individual from outbreaker2 MCMC chains. For each MCMC iteration, it counts
how many times each individual appears as an infector (alpha parameter).
}
\examples{
out_id <- identify(out, ids = linelist$name)
Ri <- get_Ri(out_id)
str(Ri)

}
