% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hal_parse.R
\name{as.data.frame}
\alias{as.data.frame}
\alias{as.data.frame.HALSearch}
\title{Coerce to a Data Frame}
\usage{
\method{as.data.frame}{HALSearch}(x, ...)
}
\arguments{
\item{x}{An object of class \code{HALSearch} (typically returned by \code{\link[=hal_search]{hal_search()}}).}

\item{...}{Currently not used.}
}
\value{
A \code{\link{data.frame}}.
}
\description{
Coerce to a \code{\link{data.frame}}, if possible.
}
\examples{
\dontrun{
## Simple search
topic <- list("archéologie", "Celtes", "France") # Combined with AND
## Get the first ten results
hal_query(topic) |>
  hal_search(limit = 10) |>
  as.data.frame()
## Get all results
hal_query(topic) |>
  hal_search(limit = 30, cursor = TRUE) |>
  as.data.frame()

## Get a list of archaeological journals
topic <- c("archéologie", "archaeology", "archäologie") # Combined with OR
hal_query(topic) |>
  hal_select("title_s", "issn_s") |>
  hal_filter("" \%TO\% "*" \%IN\% "issn_s") |>
  hal_sort("title_s") |>
  hal_search(path = "ref", instance = "journal") |>
  as.data.frame()

## Get a list of archaeological laboratories
## (only joint laboratories of the CNRS and a French university)
topic <- list("archéologie" \%IN\% "text", "UMR" \%IN\% "code_t")
hal_query(topic) |>
  hal_select("name_s", "acronym_s", "code_s") |>
  hal_filter("VALID" \%IN\% "valid_s") |>
  hal_sort("acronym_s", decreasing = TRUE) |>
  hal_search(path = "ref", instance = "structure", limit = 15) |>
  as.data.frame()
}
}
\author{
N. Frerebeau
}
\concept{results}
