% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_forest.R
\name{plot_forest}
\alias{plot_forest}
\title{plot_forest}
\usage{
plot_forest(
  p_left_data,
  point_estimate,
  ci_lower_bound,
  ci_upper_bound,
  ci_sep = ", ",
  p_right_data = NULL,
  precision_digits = 3,
  p_mid_width = 30,
  null_line_at = 1,
  output_path = NULL,
  dpi = 600,
  display = TRUE,
  font_family = c("MetroSans", "mono"),
  p_left_data_name = NULL,
  p_right_data_name = "Effect size (95\% CI)",
  stripe_colour = "#eff3f2",
  background_colour = "white",
  x_scale_linear = TRUE,
  xlim = NULL,
  xbreaks = NULL,
  nudge_y = 0,
  nudge_x = 1,
  nudge_height = 0,
  nudge_width = 0,
  justify = 0,
  arrows = FALSE,
  arrow_labels = c("Lower", "Higher"),
  risk_colors = (ggsci::pal_npg("nrc"))(2),
  arrow_nudge_y = 0,
  add_plot = NULL,
  add_plot_width = 1,
  add_plot_gap = FALSE,
  point_sizes = 3,
  point_shapes = 16,
  p_mid_forest = NULL,
  lower_header_row = FALSE,
  render_as = "png",
  table_theme = NULL
)
}
\arguments{
\item{p_left_data}{Data frame (required). The information to be displayed to the left of the forest plot.}

\item{point_estimate}{Vector. The point estimates to be displayed in the forest plot.}

\item{ci_lower_bound}{Vector. The lower confidence bounds.}

\item{ci_upper_bound}{Vector. The upper confidence bounds.}

\item{ci_sep}{String. What should separate the low and high confidence bounds? Default " to ".}

\item{p_right_data}{Data frame (optional). Information to be displayed on the right side of the table. If not supplied, an Estimate column is generated automatically.}

\item{precision_digits}{Integer. The number of decimal places on the point_estimate (default 3)}

\item{p_mid_width}{Integer. The width of forest plot in characters (default 30)}

\item{null_line_at}{Numeric. Default 1. Change to 0 if using absolute measures.}

\item{output_path}{String. Where to save the image, default tempdir().}

\item{dpi}{Numeric. The image resolution in dpi, default 600}

\item{display}{Logical. Should the file be opened? Default TRUE.}

\item{font_family}{String or character vector. The font to use for the ggplot and table. Default c("MetroSans", "mono"). The first available font is used.}

\item{p_left_data_name}{String or String Vector. The name vector for the left side data. Default NULL, which uses the column names of p_left_data.}

\item{p_right_data_name}{String. The name vector for the right side data. Default "Effect size (95\% CI)"}

\item{stripe_colour}{Hex String. Colour to use for the table stripes, default "#eff3f2".}

\item{background_colour}{Hex String or Colour Name. The colour of the background, default "white".}

\item{x_scale_linear}{Logical. Default TRUE, change to FALSE for a log scale.}

\item{xlim}{Vector. Manually specify limits for the x axis as a vector length 2, i.e. c(low, high)}

\item{xbreaks}{Vector. X axis breaks to label. Specify limits in xlim if using this option.}

\item{nudge_y}{Numeric. Allows small changes to the vertical alignment of the forest plot points. 1 unit is approximately the height of 1 row.}

\item{nudge_x}{Numeric. Nudge the alignment horizontally. Default 1. Higher values make the entire plot wider and consequently space out the elements of the figure.}

\item{nudge_height}{Numeric. Adjust the overall height of the plot output. Default is 0.}

\item{nudge_width}{Numeric. Adjust the overall width of the plot output. Default is 0.}

\item{justify}{Numeric Vector. This should be a numeric vector either of length 1 (in which case it will apply to all columns) or of length equal to the number of columns in p_left_data + 1 (for the point_estimate column). Each number in the vector dictates the column justification, with 0 being left, 0.5 being center, and 1 being right.}

\item{arrows}{Logical. Should there be arrows displayed below the ggplot? Default FALSE. Specify xlim if using arrows.}

\item{arrow_labels}{String Vector, length 2. Labels for the arrows. Set arrows to TRUE or this will have no effect.}

\item{risk_colors}{Vector. Length 2. Colors for the effect measure. Default is ggsci::pal_npg("nrc")(2).}

\item{arrow_nudge_y}{Numeric. Nudge the vertical position of the arrows. Default 0.}

\item{add_plot}{A ggplot object to add to the right side of the table. To align correctly with rows, 1 unit is the height of a row and y = 0 for the center of the bottom row.}

\item{add_plot_width}{Numeric. Width to display add_plot. Relative to the width of the forest plot, where 1 (the default) is the same width.}

\item{add_plot_gap}{Logical. Should there be space added between the plot and the main figure? Default FALSE.}

\item{point_sizes}{Vector. Length should be equal to 1 or nrow(p_left_data). The sizes of the points in the center plot, where 3.25 is the default.}

\item{point_shapes}{Vector. Length should be equal to 1 or nrow(p_left_data). The shapes of the points in the center plot, where 16 (a filled circle) is the default.}

\item{p_mid_forest}{A ggplot object to use instead of the central plot.}

\item{lower_header_row}{Logical. If TRUE, drops the header down one row (In the table rather than above it, like the default value (FALSE))}

\item{render_as}{String or Function. What output format should be used? Option is passed to ggplot2::ggsave() as the argument "device". Either pass a device function (e.g. png) or one of "eps", "ps", "tex" (pictex), "pdf", "jpeg", "tiff", "png", "bmp", "svg" or "wmf" (windows only).}

\item{table_theme}{A gridExtra table theme. If specified, overwrites all table theme customization in other options. The default is a modified version of ttheme_minimal.}
}
\value{
image
}
\description{
Creates a forest plot overlaid on a table.
}
\details{
This function creates a forest plot overlaid on a table. It is highly customizable, allowing for adjustments to fonts, colors, and layout.
}
\author{
Zhen Lu \href{mailto:luzh29@mail2.sysu.edu.cn}{luzh29@mail2.sysu.edu.cn}
}
