% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dEdq_pois.R
\name{dEdq_pois}
\alias{dEdq_pois}
\title{Compute Partial Derivatives of Expected Values for a One-Inflated Positive Poisson Model}
\usage{
dEdq_pois(b, g, X, Z, dummies, formula)
}
\arguments{
\item{b}{Numeric vector of coefficients for the main Poisson model.}

\item{g}{Numeric vector of coefficients for the one-inflation process.}

\item{X}{Matrix of predictors for the main Poisson model, where rows correspond 
to observations and columns to covariates.}

\item{Z}{Matrix of predictors for the one-inflation process, structured similarly to `X`.}

\item{dummies}{Character vector of column names from `X` and `Z` that are treated 
as dummy variables for which marginal effects are computed.}
}
\value{
A matrix of partial derivatives (or marginal effects) with rows corresponding to observations 
and columns to covariates. For dummy variables, marginal effects are calculated by contrasting 
expected values when the dummy is set to 0 versus 1.
}
\description{
This internal function calculates the partial derivatives of expected values 
for a one-inflated Poisson regression model with respect to covariates. 
It also computes marginal effects for specified dummy variables.
}
\details{
This function:
- Computes partial derivatives of expected values with respect to covariates in `X` and `Z`.
- Handles marginal effects for dummy variables by modifying their values in the design matrices 
  and computing the difference in expected values.

It is designed for internal use and assumes correct input structure. Improper inputs may result 
in errors or unexpected behavior.
}
\seealso{
\code{\link{E_pois}} for computing expected values in the one-inflated Poisson model.
}
\keyword{internal}
