% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oa2df.R
\name{keywords2df}
\alias{keywords2df}
\title{Convert keywords from list to data frame}
\usage{
keywords2df(data, verbose = TRUE)
}
\arguments{
\item{data}{List. Output of \code{oa_request}.}

\item{verbose}{Logical.
If TRUE, print information about the dataframe conversion process.
Defaults to TRUE.}
}
\value{
a data.frame.
}
\description{
The function converts a list of keywords obtained using \code{oa_request} or
\code{oa_fetch(output = "list")} into a data frame/tibble. More on keyword at
<https://help.openalex.org/hc/en-us/articles/24736201130391-Keywords>.
}
\examples{
\dontrun{

x <- oa_fetch(
  entity = "keywords",
  options = list(sample = 5),
  output = "list"
)

df <- oa2df(x, entity = "keywords")

df
}

}
