% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getQ.R
\name{getQ}
\alias{getQ}
\title{Calculate Q}
\usage{
getQ(firstStagePValue, design)
}
\arguments{
\item{firstStagePValue}{First-stage p-value or p-values. Must be a numeric vector between 0 and 1.}

\item{design}{An object of class \code{TrialDesignOptimalConditionalError} created by \code{getDesignOptimalConditionalErrorFunction()}. Contains all necessary arguments to calculate the optimal conditional error function for the specified case.}
}
\value{
Ratio of likelihood ratio and squared effect size.
}
\description{
Calculate the ratio of likelihood ratio and squared effect size.
}
\details{
For more information on how to specify the likelihood ratio, see \code{?getLikelihoodRatio()}.
In case the optimal conditional error function is ever increasing in the first-stage p-value \eqn{p_1}, a monotone transformation of \code{getQ()}
is needed for logical consistency and type I error rate control. \cr
The formula for \eqn{Q(p_1)} is:
\deqn{Q(p_1) = l(p_1) / \Delta_1^2,}
where \eqn{l(p_1)} is the likelihood ratio and \eqn{\Delta_1} is the effect size at which the conditional power should be achieved.
The effect size may also depend on the interim data (i.e., on \eqn{p_1}) in case \code{useInterimEstimate = TRUE} was specified for the design object.
}
\examples{
# Get a design
design <- getDesignOptimalConditionalErrorFunction(
alpha = 0.025, alpha1 = 0.001, alpha0 = 0.5, conditionalPower = 0.9,
delta1 = 0.25, likelihoodRatioDistribution = "fixed", deltaLR = 0.25,
firstStageInformation = 80, useInterimEstimate = FALSE,
)

getQ(firstStagePValue = c(0.05, 0.1, 0.2), design = design)

}
\references{
Brannath, W., Dreher, M., zur Verth, J., Scharpenberg, M. (2024). Optimal monotone conditional error functions. https://arxiv.org/abs/2402.00814
}
