% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{orderly_query}
\alias{orderly_query}
\title{Construct outpack query}
\usage{
orderly_query(expr, name = NULL, scope = NULL, subquery = NULL)
}
\arguments{
\item{expr}{The query expression. A \code{NULL} expression matches everything.}

\item{name}{Optionally, the name of the packet to scope the query on. This
will be intersected with \code{scope} arg and is a shorthand way of running
\code{scope = list(name = "name")}}

\item{scope}{Optionally, a scope query to limit the packets
searched by \code{pars}}

\item{subquery}{Optionally, named list of subqueries which can be
referenced by name from the \code{expr}.}
}
\value{
An \code{orderly_query} object, which should not be modified,
but which can be passed to \code{\link[=orderly_search]{orderly_search()}}
}
\description{
Construct an outpack query, typically then passed through to
\code{\link[=orderly_search]{orderly_search()}}
}
\examples{
orderly_query(quote(latest(name == "data")))
}
\seealso{
\code{vignette("dependencies")} and \code{vignette("query")}, which
discuss relationships between dependencies and the query DSL in
more detail.
}
