#' Generates counts from table frequencies for 6 category items
#'
#' @param mij Matrix of counts.
#' @returns a list containing
#'    wm1m1:  for -1, -1
#'    wm10:   for -1, 0
#'    wm11:   for -1, 1
#'    w00:    for 0, 0
#'    w01:    for 0, 1
#'    w11:    for 1, 1
Cliff_counts_6 <- function(mij) {

  wm1m1 <- (mij[2,1] * mij[2,1] + mij[2,1] * mij[3,1] + mij[2,1] * mij[4,1] + mij[2,1] * mij[5,1] + mij[2,1] * mij[6,1]
            + mij[2,2] * mij[3,1] + mij[2,2] * mij[4,1] + mij[2,2] * mij[5,1] + mij[2,2] * mij[6,1] + mij[2,3] * mij[4,1]
            + mij[2,3] * mij[5,1] + mij[2,3] * mij[6,1] + mij[2,4] * mij[5,1] + mij[2,4] * mij[6,1] + mij[2,5] * mij[6,1]
            + mij[3,1] * mij[2,1] + mij[3,1] * mij[2,2] + mij[3,1] * mij[3,1] + mij[3,1] * mij[3,2] + mij[3,1] * mij[4,1]
            + mij[3,1] * mij[4,2] + mij[3,1] * mij[5,1] + mij[3,1] * mij[5,2] + mij[3,1] * mij[6,1] + mij[3,1] * mij[6,2]
            + mij[3,2] * mij[3,1] + mij[3,2] * mij[3,2] + mij[3,2] * mij[4,1] + mij[3,2] * mij[4,2] + mij[3,2] * mij[5,1]
            + mij[3,2] * mij[5,2] + mij[3,2] * mij[6,1] + mij[3,2] * mij[6,2] + mij[3,3] * mij[4,1] + mij[3,3] * mij[4,2]
            + mij[3,3] * mij[5,1] + mij[3,3] * mij[5,2] + mij[3,3] * mij[6,1] + mij[3,3] * mij[6,2] + mij[3,4] * mij[5,1]
            + mij[3,4] * mij[5,2] + mij[3,4] * mij[6,1] + mij[3,4] * mij[6,2] + mij[3,5] * mij[6,1] + mij[3,5] * mij[6,2]
            + mij[4,1] * mij[2,1] + mij[4,1] * mij[2,2] + mij[4,1] * mij[2,3] + mij[4,1] * mij[3,1] + mij[4,1] * mij[3,2]
            + mij[4,1] * mij[3,3] + mij[4,1] * mij[4,1] + mij[4,1] * mij[4,2] + mij[4,1] * mij[4,3] + mij[4,1] * mij[5,1]
            + mij[4,1] * mij[5,2] + mij[4,1] * mij[5,3] + mij[4,1] * mij[6,1] + mij[4,1] * mij[6,2] + mij[4,1] * mij[6,3]
            + mij[4,2] * mij[3,1] + mij[4,2] * mij[3,2] + mij[4,2] * mij[3,3] + mij[4,2] * mij[4,1] + mij[4,2] * mij[4,2]
            + mij[4,2] * mij[4,3] + mij[4,2] * mij[5,1] + mij[4,2] * mij[5,2] + mij[4,2] * mij[5,3] + mij[4,2] * mij[6,1]
            + mij[4,2] * mij[6,2] + mij[4,2] * mij[6,3] + mij[4,3] * mij[4,1] + mij[4,3] * mij[4,2] + mij[4,3] * mij[4,3]
            + mij[4,3] * mij[5,1] + mij[4,3] * mij[5,2] + mij[4,3] * mij[5,3] + mij[4,3] * mij[6,1] + mij[4,3] * mij[6,2]
            + mij[4,3] * mij[6,3] + mij[4,4] * mij[5,1] + mij[4,4] * mij[5,2] + mij[4,4] * mij[5,3] + mij[4,4] * mij[6,1]
            + mij[4,4] * mij[6,2] + mij[4,4] * mij[6,3] + mij[4,5] * mij[6,1] + mij[4,5] * mij[6,2] + mij[4,5] * mij[6,3]
            + mij[5,1] * mij[2,1] + mij[5,1] * mij[2,2] + mij[5,1] * mij[2,3] + mij[5,1] * mij[2,4] + mij[5,1] * mij[3,1]
            + mij[5,1] * mij[3,2] + mij[5,1] * mij[3,3] + mij[5,1] * mij[3,4] + mij[5,1] * mij[4,1] + mij[5,1] * mij[4,2]
            + mij[5,1] * mij[4,3] + mij[5,1] * mij[4,4] + mij[5,1] * mij[5,1] + mij[5,1] * mij[5,2] + mij[5,1] * mij[5,3]
            + mij[5,1] * mij[5,4] + mij[5,1] * mij[6,1] + mij[5,1] * mij[6,2] + mij[5,1] * mij[6,3] + mij[5,1] * mij[6,4]
            + mij[5,2] * mij[3,1] + mij[5,2] * mij[3,2] + mij[5,2] * mij[3,3] + mij[5,2] * mij[3,4] + mij[5,2] * mij[4,1]
            + mij[5,2] * mij[4,2] + mij[5,2] * mij[4,3] + mij[5,2] * mij[4,4] + mij[5,2] * mij[5,1] + mij[5,2] * mij[5,2]
            + mij[5,2] * mij[5,3] + mij[5,2] * mij[5,4] + mij[5,2] * mij[6,1] + mij[5,2] * mij[6,2] + mij[5,2] * mij[6,3]
            + mij[5,2] * mij[6,4] + mij[5,3] * mij[4,1] + mij[5,3] * mij[4,2] + mij[5,3] * mij[4,3] + mij[5,3] * mij[4,4]
            + mij[5,3] * mij[5,1] + mij[5,3] * mij[5,2] + mij[5,3] * mij[5,3] + mij[5,3] * mij[5,4] + mij[5,3] * mij[6,1]
            + mij[5,3] * mij[6,2] + mij[5,3] * mij[6,3] + mij[5,3] * mij[6,4] + mij[5,4] * mij[5,1] + mij[5,4] * mij[5,2]
            + mij[5,4] * mij[5,3] + mij[5,4] * mij[5,4] + mij[5,4] * mij[6,1] + mij[5,4] * mij[6,2] + mij[5,4] * mij[6,3]
            + mij[5,4] * mij[6,4] + mij[5,5] * mij[6,1] + mij[5,5] * mij[6,2] + mij[5,5] * mij[6,3] + mij[5,5] * mij[6,4]
            + mij[6,1] * mij[2,1] + mij[6,1] * mij[2,2] + mij[6,1] * mij[2,3] + mij[6,1] * mij[2,4] + mij[6,1] * mij[2,5]
            + mij[6,1] * mij[3,1] + mij[6,1] * mij[3,2] + mij[6,1] * mij[3,3] + mij[6,1] * mij[3,4] + mij[6,1] * mij[3,5]
            + mij[6,1] * mij[4,1] + mij[6,1] * mij[4,2] + mij[6,1] * mij[4,3] + mij[6,1] * mij[4,4] + mij[6,1] * mij[4,5]
            + mij[6,1] * mij[5,1] + mij[6,1] * mij[5,2] + mij[6,1] * mij[5,3] + mij[6,1] * mij[5,4] + mij[6,1] * mij[5,5]
            + mij[6,1] * mij[6,1] + mij[6,1] * mij[6,2] + mij[6,1] * mij[6,3] + mij[6,1] * mij[6,4] + mij[6,1] * mij[6,5]
            + mij[6,2] * mij[3,1] + mij[6,2] * mij[3,2] + mij[6,2] * mij[3,3] + mij[6,2] * mij[3,4] + mij[6,2] * mij[3,5]
            + mij[6,2] * mij[4,1] + mij[6,2] * mij[4,2] + mij[6,2] * mij[4,3] + mij[6,2] * mij[4,4] + mij[6,2] * mij[4,5]
            + mij[6,2] * mij[5,1] + mij[6,2] * mij[5,2] + mij[6,2] * mij[5,3] + mij[6,2] * mij[5,4] + mij[6,2] * mij[5,5]
            + mij[6,2] * mij[6,1] + mij[6,2] * mij[6,2] + mij[6,2] * mij[6,3] + mij[6,2] * mij[6,4] + mij[6,2] * mij[6,5]
            + mij[6,3] * mij[4,1] + mij[6,3] * mij[4,2] + mij[6,3] * mij[4,3] + mij[6,3] * mij[4,4] + mij[6,3] * mij[4,5]
            + mij[6,3] * mij[5,1] + mij[6,3] * mij[5,2] + mij[6,3] * mij[5,3] + mij[6,3] * mij[5,4] + mij[6,3] * mij[5,5]
            + mij[6,3] * mij[6,1] + mij[6,3] * mij[6,2] + mij[6,3] * mij[6,3] + mij[6,3] * mij[6,4] + mij[6,3] * mij[6,5]
            + mij[6,4] * mij[5,1] + mij[6,4] * mij[5,2] + mij[6,4] * mij[5,3] + mij[6,4] * mij[5,4] + mij[6,4] * mij[5,5]
            + mij[6,4] * mij[6,1] + mij[6,4] * mij[6,2] + mij[6,4] * mij[6,3] + mij[6,4] * mij[6,4] + mij[6,4] * mij[6,5]
            + mij[6,5] * mij[6,1] + mij[6,5] * mij[6,2] + mij[6,5] * mij[6,3] + mij[6,5] * mij[6,4] + mij[6,5] * mij[6,5]
  )

  wm10 <- (mij[1,1] * mij[2,1] + mij[1,1] * mij[3,1] + mij[1,1] * mij[4,1] + mij[1,1] * mij[5,1] + mij[1,1] * mij[6,1]
           + mij[1,2] * mij[3,1] + mij[1,2] * mij[4,1] + mij[1,2] * mij[5,1] + mij[1,2] * mij[6,1] + mij[1,3] * mij[4,1]
           + mij[1,3] * mij[5,1] + mij[1,3] * mij[6,1] + mij[1,4] * mij[5,1] + mij[1,4] * mij[6,1] + mij[1,5] * mij[6,1]
           + mij[2,1] * mij[1,1] + mij[2,1] * mij[2,2] + mij[2,1] * mij[3,2] + mij[2,1] * mij[4,2] + mij[2,1] * mij[5,2]
           + mij[2,1] * mij[6,2] + mij[2,2] * mij[2,1] + mij[2,2] * mij[3,2] + mij[2,2] * mij[4,2] + mij[2,2] * mij[5,2]
           + mij[2,2] * mij[6,2] + mij[2,3] * mij[3,1] + mij[2,3] * mij[4,2] + mij[2,3] * mij[5,2] + mij[2,3] * mij[6,2]
           + mij[2,4] * mij[4,1] + mij[2,4] * mij[5,2] + mij[2,4] * mij[6,2] + mij[2,5] * mij[5,1] + mij[2,5] * mij[6,2]
           + mij[2,6] * mij[6,1] + mij[3,1] * mij[1,1] + mij[3,1] * mij[1,2] + mij[3,1] * mij[2,3] + mij[3,1] * mij[3,3]
           + mij[3,1] * mij[4,3] + mij[3,1] * mij[5,3] + mij[3,1] * mij[6,3] + mij[3,2] * mij[2,1] + mij[3,2] * mij[2,2]
           + mij[3,2] * mij[3,3] + mij[3,2] * mij[4,3] + mij[3,2] * mij[5,3] + mij[3,2] * mij[6,3] + mij[3,3] * mij[3,1]
           + mij[3,3] * mij[3,2] + mij[3,3] * mij[4,3] + mij[3,3] * mij[5,3] + mij[3,3] * mij[6,3] + mij[3,4] * mij[4,1]
           + mij[3,4] * mij[4,2] + mij[3,4] * mij[5,3] + mij[3,4] * mij[6,3] + mij[3,5] * mij[5,1] + mij[3,5] * mij[5,2]
           + mij[3,5] * mij[6,3] + mij[3,6] * mij[6,1] + mij[3,6] * mij[6,2] + mij[4,1] * mij[1,1] + mij[4,1] * mij[1,2]
           + mij[4,1] * mij[1,3] + mij[4,1] * mij[2,4] + mij[4,1] * mij[3,4] + mij[4,1] * mij[4,4] + mij[4,1] * mij[5,4]
           + mij[4,1] * mij[6,4] + mij[4,2] * mij[2,1] + mij[4,2] * mij[2,2] + mij[4,2] * mij[2,3] + mij[4,2] * mij[3,4]
           + mij[4,2] * mij[4,4] + mij[4,2] * mij[5,4] + mij[4,2] * mij[6,4] + mij[4,3] * mij[3,1] + mij[4,3] * mij[3,2]
           + mij[4,3] * mij[3,3] + mij[4,3] * mij[4,4] + mij[4,3] * mij[5,4] + mij[4,3] * mij[6,4] + mij[4,4] * mij[4,1]
           + mij[4,4] * mij[4,2] + mij[4,4] * mij[4,3] + mij[4,4] * mij[5,4] + mij[4,4] * mij[6,4] + mij[4,5] * mij[5,1]
           + mij[4,5] * mij[5,2] + mij[4,5] * mij[5,3] + mij[4,5] * mij[6,4] + mij[4,6] * mij[6,1] + mij[4,6] * mij[6,2]
           + mij[4,6] * mij[6,3] + mij[5,1] * mij[1,1] + mij[5,1] * mij[1,2] + mij[5,1] * mij[1,3] + mij[5,1] * mij[1,4]
           + mij[5,1] * mij[2,5] + mij[5,1] * mij[3,5] + mij[5,1] * mij[4,5] + mij[5,1] * mij[5,5] + mij[5,1] * mij[6,5]
           + mij[5,2] * mij[2,1] + mij[5,2] * mij[2,2] + mij[5,2] * mij[2,3] + mij[5,2] * mij[2,4] + mij[5,2] * mij[3,5]
           + mij[5,2] * mij[4,5] + mij[5,2] * mij[5,5] + mij[5,2] * mij[6,5] + mij[5,3] * mij[3,1] + mij[5,3] * mij[3,2]
           + mij[5,3] * mij[3,3] + mij[5,3] * mij[3,4] + mij[5,3] * mij[4,5] + mij[5,3] * mij[5,5] + mij[5,3] * mij[6,5]
           + mij[5,4] * mij[4,1] + mij[5,4] * mij[4,2] + mij[5,4] * mij[4,3] + mij[5,4] * mij[4,4] + mij[5,4] * mij[5,5]
           + mij[5,4] * mij[6,5] + mij[5,5] * mij[5,1] + mij[5,5] * mij[5,2] + mij[5,5] * mij[5,3] + mij[5,5] * mij[5,4]
           + mij[5,5] * mij[6,5] + mij[5,6] * mij[6,1] + mij[5,6] * mij[6,2] + mij[5,6] * mij[6,3] + mij[5,6] * mij[6,4]
           + mij[6,1] * mij[1,1] + mij[6,1] * mij[1,2] + mij[6,1] * mij[1,3] + mij[6,1] * mij[1,4] + mij[6,1] * mij[1,5]
           + mij[6,1] * mij[2,6] + mij[6,1] * mij[3,6] + mij[6,1] * mij[4,6] + mij[6,1] * mij[5,6] + mij[6,1] * mij[6,6]
           + mij[6,2] * mij[2,1] + mij[6,2] * mij[2,2] + mij[6,2] * mij[2,3] + mij[6,2] * mij[2,4] + mij[6,2] * mij[2,5]
           + mij[6,2] * mij[3,6] + mij[6,2] * mij[4,6] + mij[6,2] * mij[5,6] + mij[6,2] * mij[6,6] + mij[6,3] * mij[3,1]
           + mij[6,3] * mij[3,2] + mij[6,3] * mij[3,3] + mij[6,3] * mij[3,4] + mij[6,3] * mij[3,5] + mij[6,3] * mij[4,6]
           + mij[6,3] * mij[5,6] + mij[6,3] * mij[6,6] + mij[6,4] * mij[4,1] + mij[6,4] * mij[4,2] + mij[6,4] * mij[4,3]
           + mij[6,4] * mij[4,4] + mij[6,4] * mij[4,5] + mij[6,4] * mij[5,6] + mij[6,4] * mij[6,6] + mij[6,5] * mij[5,1]
           + mij[6,5] * mij[5,2] + mij[6,5] * mij[5,3] + mij[6,5] * mij[5,4] + mij[6,5] * mij[5,5] + mij[6,5] * mij[6,6]
           + mij[6,6] * mij[6,1] + mij[6,6] * mij[6,2] + mij[6,6] * mij[6,3] + mij[6,6] * mij[6,4] + mij[6,6] * mij[6,5]
  )

  wm11 <- (mij[1,1] * mij[2,2] + mij[1,1] * mij[2,3] + mij[1,1] * mij[2,4] + mij[1,1] * mij[2,5] + mij[1,1] * mij[2,6]
           + mij[1,1] * mij[3,2] + mij[1,1] * mij[3,3] + mij[1,1] * mij[3,4] + mij[1,1] * mij[3,5] + mij[1,1] * mij[3,6]
           + mij[1,1] * mij[4,2] + mij[1,1] * mij[4,3] + mij[1,1] * mij[4,4] + mij[1,1] * mij[4,5] + mij[1,1] * mij[4,6]
           + mij[1,1] * mij[5,2] + mij[1,1] * mij[5,3] + mij[1,1] * mij[5,4] + mij[1,1] * mij[5,5] + mij[1,1] * mij[5,6]
           + mij[1,1] * mij[6,2] + mij[1,1] * mij[6,3] + mij[1,1] * mij[6,4] + mij[1,1] * mij[6,5] + mij[1,1] * mij[6,6]
           + mij[1,2] * mij[3,2] + mij[1,2] * mij[3,3] + mij[1,2] * mij[3,4] + mij[1,2] * mij[3,5] + mij[1,2] * mij[3,6]
           + mij[1,2] * mij[4,2] + mij[1,2] * mij[4,3] + mij[1,2] * mij[4,4] + mij[1,2] * mij[4,5] + mij[1,2] * mij[4,6]
           + mij[1,2] * mij[5,2] + mij[1,2] * mij[5,3] + mij[1,2] * mij[5,4] + mij[1,2] * mij[5,5] + mij[1,2] * mij[5,6]
           + mij[1,2] * mij[6,2] + mij[1,2] * mij[6,3] + mij[1,2] * mij[6,4] + mij[1,2] * mij[6,5] + mij[1,2] * mij[6,6]
           + mij[1,3] * mij[4,2] + mij[1,3] * mij[4,3] + mij[1,3] * mij[4,4] + mij[1,3] * mij[4,5] + mij[1,3] * mij[4,6]
           + mij[1,3] * mij[5,2] + mij[1,3] * mij[5,3] + mij[1,3] * mij[5,4] + mij[1,3] * mij[5,5] + mij[1,3] * mij[5,6]
           + mij[1,3] * mij[6,2] + mij[1,3] * mij[6,3] + mij[1,3] * mij[6,4] + mij[1,3] * mij[6,5] + mij[1,3] * mij[6,6]
           + mij[1,4] * mij[5,2] + mij[1,4] * mij[5,3] + mij[1,4] * mij[5,4] + mij[1,4] * mij[5,5] + mij[1,4] * mij[5,6]
           + mij[1,4] * mij[6,2] + mij[1,4] * mij[6,3] + mij[1,4] * mij[6,4] + mij[1,4] * mij[6,5] + mij[1,4] * mij[6,6]
           + mij[1,5] * mij[6,2] + mij[1,5] * mij[6,3] + mij[1,5] * mij[6,4] + mij[1,5] * mij[6,5] + mij[1,5] * mij[6,6]
           + mij[2,1] * mij[2,3] + mij[2,1] * mij[2,4] + mij[2,1] * mij[2,5] + mij[2,1] * mij[2,6] + mij[2,1] * mij[3,3]
           + mij[2,1] * mij[3,4] + mij[2,1] * mij[3,5] + mij[2,1] * mij[3,6] + mij[2,1] * mij[4,3] + mij[2,1] * mij[4,4]
           + mij[2,1] * mij[4,5] + mij[2,1] * mij[4,6] + mij[2,1] * mij[5,3] + mij[2,1] * mij[5,4] + mij[2,1] * mij[5,5]
           + mij[2,1] * mij[5,6] + mij[2,1] * mij[6,3] + mij[2,1] * mij[6,4] + mij[2,1] * mij[6,5] + mij[2,1] * mij[6,6]
           + mij[2,2] * mij[1,1] + mij[2,2] * mij[3,3] + mij[2,2] * mij[3,4] + mij[2,2] * mij[3,5] + mij[2,2] * mij[3,6]
           + mij[2,2] * mij[4,3] + mij[2,2] * mij[4,4] + mij[2,2] * mij[4,5] + mij[2,2] * mij[4,6] + mij[2,2] * mij[5,3]
           + mij[2,2] * mij[5,4] + mij[2,2] * mij[5,5] + mij[2,2] * mij[5,6] + mij[2,2] * mij[6,3] + mij[2,2] * mij[6,4]
           + mij[2,2] * mij[6,5] + mij[2,2] * mij[6,6] + mij[2,3] * mij[1,1] + mij[2,3] * mij[2,1] + mij[2,3] * mij[4,3]
           + mij[2,3] * mij[4,4] + mij[2,3] * mij[4,5] + mij[2,3] * mij[4,6] + mij[2,3] * mij[5,3] + mij[2,3] * mij[5,4]
           + mij[2,3] * mij[5,5] + mij[2,3] * mij[5,6] + mij[2,3] * mij[6,3] + mij[2,3] * mij[6,4] + mij[2,3] * mij[6,5]
           + mij[2,3] * mij[6,6] + mij[2,4] * mij[1,1] + mij[2,4] * mij[2,1] + mij[2,4] * mij[3,1] + mij[2,4] * mij[5,3]
           + mij[2,4] * mij[5,4] + mij[2,4] * mij[5,5] + mij[2,4] * mij[5,6] + mij[2,4] * mij[6,3] + mij[2,4] * mij[6,4]
           + mij[2,4] * mij[6,5] + mij[2,4] * mij[6,6] + mij[2,5] * mij[1,1] + mij[2,5] * mij[2,1] + mij[2,5] * mij[3,1]
           + mij[2,5] * mij[4,1] + mij[2,5] * mij[6,3] + mij[2,5] * mij[6,4] + mij[2,5] * mij[6,5] + mij[2,5] * mij[6,6]
           + mij[2,6] * mij[1,1] + mij[2,6] * mij[2,1] + mij[2,6] * mij[3,1] + mij[2,6] * mij[4,1] + mij[2,6] * mij[5,1]
           + mij[3,1] * mij[2,4] + mij[3,1] * mij[2,5] + mij[3,1] * mij[2,6] + mij[3,1] * mij[3,4] + mij[3,1] * mij[3,5]
           + mij[3,1] * mij[3,6] + mij[3,1] * mij[4,4] + mij[3,1] * mij[4,5] + mij[3,1] * mij[4,6] + mij[3,1] * mij[5,4]
           + mij[3,1] * mij[5,5] + mij[3,1] * mij[5,6] + mij[3,1] * mij[6,4] + mij[3,1] * mij[6,5] + mij[3,1] * mij[6,6]
           + mij[3,2] * mij[1,1] + mij[3,2] * mij[1,2] + mij[3,2] * mij[3,4] + mij[3,2] * mij[3,5] + mij[3,2] * mij[3,6]
           + mij[3,2] * mij[4,4] + mij[3,2] * mij[4,5] + mij[3,2] * mij[4,6] + mij[3,2] * mij[5,4] + mij[3,2] * mij[5,5]
           + mij[3,2] * mij[5,6] + mij[3,2] * mij[6,4] + mij[3,2] * mij[6,5] + mij[3,2] * mij[6,6] + mij[3,3] * mij[1,1]
           + mij[3,3] * mij[1,2] + mij[3,3] * mij[2,1] + mij[3,3] * mij[2,2] + mij[3,3] * mij[4,4] + mij[3,3] * mij[4,5]
           + mij[3,3] * mij[4,6] + mij[3,3] * mij[5,4] + mij[3,3] * mij[5,5] + mij[3,3] * mij[5,6] + mij[3,3] * mij[6,4]
           + mij[3,3] * mij[6,5] + mij[3,3] * mij[6,6] + mij[3,4] * mij[1,1] + mij[3,4] * mij[1,2] + mij[3,4] * mij[2,1]
           + mij[3,4] * mij[2,2] + mij[3,4] * mij[3,1] + mij[3,4] * mij[3,2] + mij[3,4] * mij[5,4] + mij[3,4] * mij[5,5]
           + mij[3,4] * mij[5,6] + mij[3,4] * mij[6,4] + mij[3,4] * mij[6,5] + mij[3,4] * mij[6,6] + mij[3,5] * mij[1,1]
           + mij[3,5] * mij[1,2] + mij[3,5] * mij[2,1] + mij[3,5] * mij[2,2] + mij[3,5] * mij[3,1] + mij[3,5] * mij[3,2]
           + mij[3,5] * mij[4,1] + mij[3,5] * mij[4,2] + mij[3,5] * mij[6,4] + mij[3,5] * mij[6,5] + mij[3,5] * mij[6,6]
           + mij[3,6] * mij[1,1] + mij[3,6] * mij[1,2] + mij[3,6] * mij[2,1] + mij[3,6] * mij[2,2] + mij[3,6] * mij[3,1]
           + mij[3,6] * mij[3,2] + mij[3,6] * mij[4,1] + mij[3,6] * mij[4,2] + mij[3,6] * mij[5,1] + mij[3,6] * mij[5,2]
           + mij[4,1] * mij[2,5] + mij[4,1] * mij[2,6] + mij[4,1] * mij[3,5] + mij[4,1] * mij[3,6] + mij[4,1] * mij[4,5]
           + mij[4,1] * mij[4,6] + mij[4,1] * mij[5,5] + mij[4,1] * mij[5,6] + mij[4,1] * mij[6,5] + mij[4,1] * mij[6,6]
           + mij[4,2] * mij[1,1] + mij[4,2] * mij[1,2] + mij[4,2] * mij[1,3] + mij[4,2] * mij[3,5] + mij[4,2] * mij[3,6]
           + mij[4,2] * mij[4,5] + mij[4,2] * mij[4,6] + mij[4,2] * mij[5,5] + mij[4,2] * mij[5,6] + mij[4,2] * mij[6,5]
           + mij[4,2] * mij[6,6] + mij[4,3] * mij[1,1] + mij[4,3] * mij[1,2] + mij[4,3] * mij[1,3] + mij[4,3] * mij[2,1]
           + mij[4,3] * mij[2,2] + mij[4,3] * mij[2,3] + mij[4,3] * mij[4,5] + mij[4,3] * mij[4,6] + mij[4,3] * mij[5,5]
           + mij[4,3] * mij[5,6] + mij[4,3] * mij[6,5] + mij[4,3] * mij[6,6] + mij[4,4] * mij[1,1] + mij[4,4] * mij[1,2]
           + mij[4,4] * mij[1,3] + mij[4,4] * mij[2,1] + mij[4,4] * mij[2,2] + mij[4,4] * mij[2,3] + mij[4,4] * mij[3,1]
           + mij[4,4] * mij[3,2] + mij[4,4] * mij[3,3] + mij[4,4] * mij[5,5] + mij[4,4] * mij[5,6] + mij[4,4] * mij[6,5]
           + mij[4,4] * mij[6,6] + mij[4,5] * mij[1,1] + mij[4,5] * mij[1,2] + mij[4,5] * mij[1,3] + mij[4,5] * mij[2,1]
           + mij[4,5] * mij[2,2] + mij[4,5] * mij[2,3] + mij[4,5] * mij[3,1] + mij[4,5] * mij[3,2] + mij[4,5] * mij[3,3]
           + mij[4,5] * mij[4,1] + mij[4,5] * mij[4,2] + mij[4,5] * mij[4,3] + mij[4,5] * mij[6,5] + mij[4,5] * mij[6,6]
           + mij[4,6] * mij[1,1] + mij[4,6] * mij[1,2] + mij[4,6] * mij[1,3] + mij[4,6] * mij[2,1] + mij[4,6] * mij[2,2]
           + mij[4,6] * mij[2,3] + mij[4,6] * mij[3,1] + mij[4,6] * mij[3,2] + mij[4,6] * mij[3,3] + mij[4,6] * mij[4,1]
           + mij[4,6] * mij[4,2] + mij[4,6] * mij[4,3] + mij[4,6] * mij[5,1] + mij[4,6] * mij[5,2] + mij[4,6] * mij[5,3]
           + mij[5,1] * mij[2,6] + mij[5,1] * mij[3,6] + mij[5,1] * mij[4,6] + mij[5,1] * mij[5,6] + mij[5,1] * mij[6,6]
           + mij[5,2] * mij[1,1] + mij[5,2] * mij[1,2] + mij[5,2] * mij[1,3] + mij[5,2] * mij[1,4] + mij[5,2] * mij[3,6]
           + mij[5,2] * mij[4,6] + mij[5,2] * mij[5,6] + mij[5,2] * mij[6,6] + mij[5,3] * mij[1,1] + mij[5,3] * mij[1,2]
           + mij[5,3] * mij[1,3] + mij[5,3] * mij[1,4] + mij[5,3] * mij[2,1] + mij[5,3] * mij[2,2] + mij[5,3] * mij[2,3]
           + mij[5,3] * mij[2,4] + mij[5,3] * mij[4,6] + mij[5,3] * mij[5,6] + mij[5,3] * mij[6,6] + mij[5,4] * mij[1,1]
           + mij[5,4] * mij[1,2] + mij[5,4] * mij[1,3] + mij[5,4] * mij[1,4] + mij[5,4] * mij[2,1] + mij[5,4] * mij[2,2]
           + mij[5,4] * mij[2,3] + mij[5,4] * mij[2,4] + mij[5,4] * mij[3,1] + mij[5,4] * mij[3,2] + mij[5,4] * mij[3,3]
           + mij[5,4] * mij[3,4] + mij[5,4] * mij[5,6] + mij[5,4] * mij[6,6] + mij[5,5] * mij[1,1] + mij[5,5] * mij[1,2]
           + mij[5,5] * mij[1,3] + mij[5,5] * mij[1,4] + mij[5,5] * mij[2,1] + mij[5,5] * mij[2,2] + mij[5,5] * mij[2,3]
           + mij[5,5] * mij[2,4] + mij[5,5] * mij[3,1] + mij[5,5] * mij[3,2] + mij[5,5] * mij[3,3] + mij[5,5] * mij[3,4]
           + mij[5,5] * mij[4,1] + mij[5,5] * mij[4,2] + mij[5,5] * mij[4,3] + mij[5,5] * mij[4,4] + mij[5,5] * mij[6,6]
           + mij[5,6] * mij[1,1] + mij[5,6] * mij[1,2] + mij[5,6] * mij[1,3] + mij[5,6] * mij[1,4] + mij[5,6] * mij[2,1]
           + mij[5,6] * mij[2,2] + mij[5,6] * mij[2,3] + mij[5,6] * mij[2,4] + mij[5,6] * mij[3,1] + mij[5,6] * mij[3,2]
           + mij[5,6] * mij[3,3] + mij[5,6] * mij[3,4] + mij[5,6] * mij[4,1] + mij[5,6] * mij[4,2] + mij[5,6] * mij[4,3]
           + mij[5,6] * mij[4,4] + mij[5,6] * mij[5,1] + mij[5,6] * mij[5,2] + mij[5,6] * mij[5,3] + mij[5,6] * mij[5,4]
           + mij[6,2] * mij[1,1] + mij[6,2] * mij[1,2] + mij[6,2] * mij[1,3] + mij[6,2] * mij[1,4] + mij[6,2] * mij[1,5]
           + mij[6,3] * mij[1,1] + mij[6,3] * mij[1,2] + mij[6,3] * mij[1,3] + mij[6,3] * mij[1,4] + mij[6,3] * mij[1,5]
           + mij[6,3] * mij[2,1] + mij[6,3] * mij[2,2] + mij[6,3] * mij[2,3] + mij[6,3] * mij[2,4] + mij[6,3] * mij[2,5]
           + mij[6,4] * mij[1,1] + mij[6,4] * mij[1,2] + mij[6,4] * mij[1,3] + mij[6,4] * mij[1,4] + mij[6,4] * mij[1,5]
           + mij[6,4] * mij[2,1] + mij[6,4] * mij[2,2] + mij[6,4] * mij[2,3] + mij[6,4] * mij[2,4] + mij[6,4] * mij[2,5]
           + mij[6,4] * mij[3,1] + mij[6,4] * mij[3,2] + mij[6,4] * mij[3,3] + mij[6,4] * mij[3,4] + mij[6,4] * mij[3,5]
           + mij[6,5] * mij[1,1] + mij[6,5] * mij[1,2] + mij[6,5] * mij[1,3] + mij[6,5] * mij[1,4] + mij[6,5] * mij[1,5]
           + mij[6,5] * mij[2,1] + mij[6,5] * mij[2,2] + mij[6,5] * mij[2,3] + mij[6,5] * mij[2,4] + mij[6,5] * mij[2,5]
           + mij[6,5] * mij[3,1] + mij[6,5] * mij[3,2] + mij[6,5] * mij[3,3] + mij[6,5] * mij[3,4] + mij[6,5] * mij[3,5]
           + mij[6,5] * mij[4,1] + mij[6,5] * mij[4,2] + mij[6,5] * mij[4,3] + mij[6,5] * mij[4,4] + mij[6,5] * mij[4,5]
           + mij[6,6] * mij[1,1] + mij[6,6] * mij[1,2] + mij[6,6] * mij[1,3] + mij[6,6] * mij[1,4] + mij[6,6] * mij[1,5]
           + mij[6,6] * mij[2,1] + mij[6,6] * mij[2,2] + mij[6,6] * mij[2,3] + mij[6,6] * mij[2,4] + mij[6,6] * mij[2,5]
           + mij[6,6] * mij[3,1] + mij[6,6] * mij[3,2] + mij[6,6] * mij[3,3] + mij[6,6] * mij[3,4] + mij[6,6] * mij[3,5]
           + mij[6,6] * mij[4,1] + mij[6,6] * mij[4,2] + mij[6,6] * mij[4,3] + mij[6,6] * mij[4,4] + mij[6,6] * mij[4,5]
           + mij[6,6] * mij[5,1] + mij[6,6] * mij[5,2] + mij[6,6] * mij[5,3] + mij[6,6] * mij[5,4] + mij[6,6] * mij[5,5]
  )

  w00 <- (mij[1,1] * mij[1,1] + mij[1,2] * mij[2,1] + mij[1,3] * mij[3,1] + mij[1,4] * mij[4,1] + mij[1,5] * mij[5,1]
          + mij[1,6] * mij[6,1] + mij[2,1] * mij[1,2] + mij[2,2] * mij[2,2] + mij[2,3] * mij[3,2] + mij[2,4] * mij[4,2]
          + mij[2,5] * mij[5,2] + mij[2,6] * mij[6,2] + mij[3,1] * mij[1,3] + mij[3,2] * mij[2,3] + mij[3,3] * mij[3,3]
          + mij[3,4] * mij[4,3] + mij[3,5] * mij[5,3] + mij[3,6] * mij[6,3] + mij[4,1] * mij[1,4] + mij[4,2] * mij[2,4]
          + mij[4,3] * mij[3,4] + mij[4,4] * mij[4,4] + mij[4,5] * mij[5,4] + mij[4,6] * mij[6,4] + mij[5,1] * mij[1,5]
          + mij[5,2] * mij[2,5] + mij[5,3] * mij[3,5] + mij[5,4] * mij[4,5] + mij[5,5] * mij[5,5] + mij[5,6] * mij[6,5]
          + mij[6,1] * mij[1,6] + mij[6,2] * mij[2,6] + mij[6,3] * mij[3,6] + mij[6,4] * mij[4,6] + mij[6,5] * mij[5,6]
          + mij[6,6] * mij[6,6]
  )

  w01 <- (mij[1,1] * mij[1,2] + mij[1,1] * mij[1,3] + mij[1,1] * mij[1,4] + mij[1,1] * mij[1,5] + mij[1,1] * mij[1,6]
          + mij[1,2] * mij[1,1] + mij[1,2] * mij[2,2] + mij[1,2] * mij[2,3] + mij[1,2] * mij[2,4] + mij[1,2] * mij[2,5]
          + mij[1,2] * mij[2,6] + mij[1,3] * mij[1,1] + mij[1,3] * mij[2,1] + mij[1,3] * mij[3,2] + mij[1,3] * mij[3,3]
          + mij[1,3] * mij[3,4] + mij[1,3] * mij[3,5] + mij[1,3] * mij[3,6] + mij[1,4] * mij[1,1] + mij[1,4] * mij[2,1]
          + mij[1,4] * mij[3,1] + mij[1,4] * mij[4,2] + mij[1,4] * mij[4,3] + mij[1,4] * mij[4,4] + mij[1,4] * mij[4,5]
          + mij[1,4] * mij[4,6] + mij[1,5] * mij[1,1] + mij[1,5] * mij[2,1] + mij[1,5] * mij[3,1] + mij[1,5] * mij[4,1]
          + mij[1,5] * mij[5,2] + mij[1,5] * mij[5,3] + mij[1,5] * mij[5,4] + mij[1,5] * mij[5,5] + mij[1,5] * mij[5,6]
          + mij[1,6] * mij[1,1] + mij[1,6] * mij[2,1] + mij[1,6] * mij[3,1] + mij[1,6] * mij[4,1] + mij[1,6] * mij[5,1]
          + mij[1,6] * mij[6,2] + mij[1,6] * mij[6,3] + mij[1,6] * mij[6,4] + mij[1,6] * mij[6,5] + mij[1,6] * mij[6,6]
          + mij[2,1] * mij[1,3] + mij[2,1] * mij[1,4] + mij[2,1] * mij[1,5] + mij[2,1] * mij[1,6] + mij[2,2] * mij[1,2]
          + mij[2,2] * mij[2,3] + mij[2,2] * mij[2,4] + mij[2,2] * mij[2,5] + mij[2,2] * mij[2,6] + mij[2,3] * mij[1,2]
          + mij[2,3] * mij[2,2] + mij[2,3] * mij[3,3] + mij[2,3] * mij[3,4] + mij[2,3] * mij[3,5] + mij[2,3] * mij[3,6]
          + mij[2,4] * mij[1,2] + mij[2,4] * mij[2,2] + mij[2,4] * mij[3,2] + mij[2,4] * mij[4,3] + mij[2,4] * mij[4,4]
          + mij[2,4] * mij[4,5] + mij[2,4] * mij[4,6] + mij[2,5] * mij[1,2] + mij[2,5] * mij[2,2] + mij[2,5] * mij[3,2]
          + mij[2,5] * mij[4,2] + mij[2,5] * mij[5,3] + mij[2,5] * mij[5,4] + mij[2,5] * mij[5,5] + mij[2,5] * mij[5,6]
          + mij[2,6] * mij[1,2] + mij[2,6] * mij[2,2] + mij[2,6] * mij[3,2] + mij[2,6] * mij[4,2] + mij[2,6] * mij[5,2]
          + mij[2,6] * mij[6,3] + mij[2,6] * mij[6,4] + mij[2,6] * mij[6,5] + mij[2,6] * mij[6,6] + mij[3,1] * mij[1,4]
          + mij[3,1] * mij[1,5] + mij[3,1] * mij[1,6] + mij[3,2] * mij[1,3] + mij[3,2] * mij[2,4] + mij[3,2] * mij[2,5]
          + mij[3,2] * mij[2,6] + mij[3,3] * mij[1,3] + mij[3,3] * mij[2,3] + mij[3,3] * mij[3,4] + mij[3,3] * mij[3,5]
          + mij[3,3] * mij[3,6] + mij[3,4] * mij[1,3] + mij[3,4] * mij[2,3] + mij[3,4] * mij[3,3] + mij[3,4] * mij[4,4]
          + mij[3,4] * mij[4,5] + mij[3,4] * mij[4,6] + mij[3,5] * mij[1,3] + mij[3,5] * mij[2,3] + mij[3,5] * mij[3,3]
          + mij[3,5] * mij[4,3] + mij[3,5] * mij[5,4] + mij[3,5] * mij[5,5] + mij[3,5] * mij[5,6] + mij[3,6] * mij[1,3]
          + mij[3,6] * mij[2,3] + mij[3,6] * mij[3,3] + mij[3,6] * mij[4,3] + mij[3,6] * mij[5,3] + mij[3,6] * mij[6,4]
          + mij[3,6] * mij[6,5] + mij[3,6] * mij[6,6] + mij[4,1] * mij[1,5] + mij[4,1] * mij[1,6] + mij[4,2] * mij[1,4]
          + mij[4,2] * mij[2,5] + mij[4,2] * mij[2,6] + mij[4,3] * mij[1,4] + mij[4,3] * mij[2,4] + mij[4,3] * mij[3,5]
          + mij[4,3] * mij[3,6] + mij[4,4] * mij[1,4] + mij[4,4] * mij[2,4] + mij[4,4] * mij[3,4] + mij[4,4] * mij[4,5]
          + mij[4,4] * mij[4,6] + mij[4,5] * mij[1,4] + mij[4,5] * mij[2,4] + mij[4,5] * mij[3,4] + mij[4,5] * mij[4,4]
          + mij[4,5] * mij[5,5] + mij[4,5] * mij[5,6] + mij[4,6] * mij[1,4] + mij[4,6] * mij[2,4] + mij[4,6] * mij[3,4]
          + mij[4,6] * mij[4,4] + mij[4,6] * mij[5,4] + mij[4,6] * mij[6,5] + mij[4,6] * mij[6,6] + mij[5,1] * mij[1,6]
          + mij[5,2] * mij[1,5] + mij[5,2] * mij[2,6] + mij[5,3] * mij[1,5] + mij[5,3] * mij[2,5] + mij[5,3] * mij[3,6]
          + mij[5,4] * mij[1,5] + mij[5,4] * mij[2,5] + mij[5,4] * mij[3,5] + mij[5,4] * mij[4,6] + mij[5,5] * mij[1,5]
          + mij[5,5] * mij[2,5] + mij[5,5] * mij[3,5] + mij[5,5] * mij[4,5] + mij[5,5] * mij[5,6] + mij[5,6] * mij[1,5]
          + mij[5,6] * mij[2,5] + mij[5,6] * mij[3,5] + mij[5,6] * mij[4,5] + mij[5,6] * mij[5,5] + mij[5,6] * mij[6,6]
          + mij[6,2] * mij[1,6] + mij[6,3] * mij[1,6] + mij[6,3] * mij[2,6] + mij[6,4] * mij[1,6] + mij[6,4] * mij[2,6]
          + mij[6,4] * mij[3,6] + mij[6,5] * mij[1,6] + mij[6,5] * mij[2,6] + mij[6,5] * mij[3,6] + mij[6,5] * mij[4,6]
          + mij[6,6] * mij[1,6] + mij[6,6] * mij[2,6] + mij[6,6] * mij[3,6] + mij[6,6] * mij[4,6] + mij[6,6] * mij[5,6]
  )

  w11 <- (mij[1,2] * mij[1,2] + mij[1,2] * mij[1,3] + mij[1,2] * mij[1,4] + mij[1,2] * mij[1,5] + mij[1,2] * mij[1,6]
          + mij[1,3] * mij[1,2] + mij[1,3] * mij[1,3] + mij[1,3] * mij[1,4] + mij[1,3] * mij[1,5] + mij[1,3] * mij[1,6]
          + mij[1,3] * mij[2,2] + mij[1,3] * mij[2,3] + mij[1,3] * mij[2,4] + mij[1,3] * mij[2,5] + mij[1,3] * mij[2,6]
          + mij[1,4] * mij[1,2] + mij[1,4] * mij[1,3] + mij[1,4] * mij[1,4] + mij[1,4] * mij[1,5] + mij[1,4] * mij[1,6]
          + mij[1,4] * mij[2,2] + mij[1,4] * mij[2,3] + mij[1,4] * mij[2,4] + mij[1,4] * mij[2,5] + mij[1,4] * mij[2,6]
          + mij[1,4] * mij[3,2] + mij[1,4] * mij[3,3] + mij[1,4] * mij[3,4] + mij[1,4] * mij[3,5] + mij[1,4] * mij[3,6]
          + mij[1,5] * mij[1,2] + mij[1,5] * mij[1,3] + mij[1,5] * mij[1,4] + mij[1,5] * mij[1,5] + mij[1,5] * mij[1,6]
          + mij[1,5] * mij[2,2] + mij[1,5] * mij[2,3] + mij[1,5] * mij[2,4] + mij[1,5] * mij[2,5] + mij[1,5] * mij[2,6]
          + mij[1,5] * mij[3,2] + mij[1,5] * mij[3,3] + mij[1,5] * mij[3,4] + mij[1,5] * mij[3,5] + mij[1,5] * mij[3,6]
          + mij[1,5] * mij[4,2] + mij[1,5] * mij[4,3] + mij[1,5] * mij[4,4] + mij[1,5] * mij[4,5] + mij[1,5] * mij[4,6]
          + mij[1,6] * mij[1,2] + mij[1,6] * mij[1,3] + mij[1,6] * mij[1,4] + mij[1,6] * mij[1,5] + mij[1,6] * mij[1,6]
          + mij[1,6] * mij[2,2] + mij[1,6] * mij[2,3] + mij[1,6] * mij[2,4] + mij[1,6] * mij[2,5] + mij[1,6] * mij[2,6]
          + mij[1,6] * mij[3,2] + mij[1,6] * mij[3,3] + mij[1,6] * mij[3,4] + mij[1,6] * mij[3,5] + mij[1,6] * mij[3,6]
          + mij[1,6] * mij[4,2] + mij[1,6] * mij[4,3] + mij[1,6] * mij[4,4] + mij[1,6] * mij[4,5] + mij[1,6] * mij[4,6]
          + mij[1,6] * mij[5,2] + mij[1,6] * mij[5,3] + mij[1,6] * mij[5,4] + mij[1,6] * mij[5,5] + mij[1,6] * mij[5,6]
          + mij[2,2] * mij[1,3] + mij[2,2] * mij[1,4] + mij[2,2] * mij[1,5] + mij[2,2] * mij[1,6] + mij[2,3] * mij[1,3]
          + mij[2,3] * mij[1,4] + mij[2,3] * mij[1,5] + mij[2,3] * mij[1,6] + mij[2,3] * mij[2,3] + mij[2,3] * mij[2,4]
          + mij[2,3] * mij[2,5] + mij[2,3] * mij[2,6] + mij[2,4] * mij[1,3] + mij[2,4] * mij[1,4] + mij[2,4] * mij[1,5]
          + mij[2,4] * mij[1,6] + mij[2,4] * mij[2,3] + mij[2,4] * mij[2,4] + mij[2,4] * mij[2,5] + mij[2,4] * mij[2,6]
          + mij[2,4] * mij[3,3] + mij[2,4] * mij[3,4] + mij[2,4] * mij[3,5] + mij[2,4] * mij[3,6] + mij[2,5] * mij[1,3]
          + mij[2,5] * mij[1,4] + mij[2,5] * mij[1,5] + mij[2,5] * mij[1,6] + mij[2,5] * mij[2,3] + mij[2,5] * mij[2,4]
          + mij[2,5] * mij[2,5] + mij[2,5] * mij[2,6] + mij[2,5] * mij[3,3] + mij[2,5] * mij[3,4] + mij[2,5] * mij[3,5]
          + mij[2,5] * mij[3,6] + mij[2,5] * mij[4,3] + mij[2,5] * mij[4,4] + mij[2,5] * mij[4,5] + mij[2,5] * mij[4,6]
          + mij[2,6] * mij[1,3] + mij[2,6] * mij[1,4] + mij[2,6] * mij[1,5] + mij[2,6] * mij[1,6] + mij[2,6] * mij[2,3]
          + mij[2,6] * mij[2,4] + mij[2,6] * mij[2,5] + mij[2,6] * mij[2,6] + mij[2,6] * mij[3,3] + mij[2,6] * mij[3,4]
          + mij[2,6] * mij[3,5] + mij[2,6] * mij[3,6] + mij[2,6] * mij[4,3] + mij[2,6] * mij[4,4] + mij[2,6] * mij[4,5]
          + mij[2,6] * mij[4,6] + mij[2,6] * mij[5,3] + mij[2,6] * mij[5,4] + mij[2,6] * mij[5,5] + mij[2,6] * mij[5,6]
          + mij[3,2] * mij[1,4] + mij[3,2] * mij[1,5] + mij[3,2] * mij[1,6] + mij[3,3] * mij[1,4] + mij[3,3] * mij[1,5]
          + mij[3,3] * mij[1,6] + mij[3,3] * mij[2,4] + mij[3,3] * mij[2,5] + mij[3,3] * mij[2,6] + mij[3,4] * mij[1,4]
          + mij[3,4] * mij[1,5] + mij[3,4] * mij[1,6] + mij[3,4] * mij[2,4] + mij[3,4] * mij[2,5] + mij[3,4] * mij[2,6]
          + mij[3,4] * mij[3,4] + mij[3,4] * mij[3,5] + mij[3,4] * mij[3,6] + mij[3,5] * mij[1,4] + mij[3,5] * mij[1,5]
          + mij[3,5] * mij[1,6] + mij[3,5] * mij[2,4] + mij[3,5] * mij[2,5] + mij[3,5] * mij[2,6] + mij[3,5] * mij[3,4]
          + mij[3,5] * mij[3,5] + mij[3,5] * mij[3,6] + mij[3,5] * mij[4,4] + mij[3,5] * mij[4,5] + mij[3,5] * mij[4,6]
          + mij[3,6] * mij[1,4] + mij[3,6] * mij[1,5] + mij[3,6] * mij[1,6] + mij[3,6] * mij[2,4] + mij[3,6] * mij[2,5]
          + mij[3,6] * mij[2,6] + mij[3,6] * mij[3,4] + mij[3,6] * mij[3,5] + mij[3,6] * mij[3,6] + mij[3,6] * mij[4,4]
          + mij[3,6] * mij[4,5] + mij[3,6] * mij[4,6] + mij[3,6] * mij[5,4] + mij[3,6] * mij[5,5] + mij[3,6] * mij[5,6]
          + mij[4,2] * mij[1,5] + mij[4,2] * mij[1,6] + mij[4,3] * mij[1,5] + mij[4,3] * mij[1,6] + mij[4,3] * mij[2,5]
          + mij[4,3] * mij[2,6] + mij[4,4] * mij[1,5] + mij[4,4] * mij[1,6] + mij[4,4] * mij[2,5] + mij[4,4] * mij[2,6]
          + mij[4,4] * mij[3,5] + mij[4,4] * mij[3,6] + mij[4,5] * mij[1,5] + mij[4,5] * mij[1,6] + mij[4,5] * mij[2,5]
          + mij[4,5] * mij[2,6] + mij[4,5] * mij[3,5] + mij[4,5] * mij[3,6] + mij[4,5] * mij[4,5] + mij[4,5] * mij[4,6]
          + mij[4,6] * mij[1,5] + mij[4,6] * mij[1,6] + mij[4,6] * mij[2,5] + mij[4,6] * mij[2,6] + mij[4,6] * mij[3,5]
          + mij[4,6] * mij[3,6] + mij[4,6] * mij[4,5] + mij[4,6] * mij[4,6] + mij[4,6] * mij[5,5] + mij[4,6] * mij[5,6]
          + mij[5,2] * mij[1,6] + mij[5,3] * mij[1,6] + mij[5,3] * mij[2,6] + mij[5,4] * mij[1,6] + mij[5,4] * mij[2,6]
          + mij[5,4] * mij[3,6] + mij[5,5] * mij[1,6] + mij[5,5] * mij[2,6] + mij[5,5] * mij[3,6] + mij[5,5] * mij[4,6]
          + mij[5,6] * mij[1,6] + mij[5,6] * mij[2,6] + mij[5,6] * mij[3,6] + mij[5,6] * mij[4,6] + mij[5,6] * mij[5,6]
  )

  result <- list("wm1m1" = wm1m1, "wm10" = wm10, "wm11" = wm11,
                 "w00" = w00, "w01" = w01, "w11" = w11)

  result
}
