% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cliff_dependent.R
\name{Cliff_dependent_compute_from_table}
\alias{Cliff_dependent_compute_from_table}
\title{Computes Cliff's dependent d-statistics based on a table of frequency counts.}
\usage{
Cliff_dependent_compute_from_table(mij)
}
\arguments{
\item{mij}{an r x r table of paired observations}
}
\value{
a list containing
   dw: within-subjects d-statistic
   sigma_dw: SE of dw
   z_dw: z-score for dw
   db: between-susbjects d-statistic
   sigma_db: SE of db
   z_db: z-score for db
   db_dw: sum db + dw, omnibus measure
   sigma_db_dw: SE of db + dw
   z_db_dw: z-score of db _ dw
   cov_db_dw: covariance between db and dw
}
\description{
Takes the r X r table and returns:
dw - within-subjects d-statistic
db - between-subjects d-statistic
db_dw - sum of dw and db, omnibus test of whether one group is higher than the other
No intermediate dominance matrix is computed, so this is much faster than
Cliff_dependent_compute_from_matrix().
Large number of terms are needed to compute intermediate d_ij_ji.  These are contained
in separate functions for r <= 6.  Results for r [7, 10] are available, but the files are
so large that they cause an error if included in the library.
}
\details{
See:
Cliff, N. (1993). Dominance statistics: Ordinal analyses to answer ordinal questions.
Psychological Bulletin, 114(3), 494-509.
Cliff, N. (1996). Ordinal methods for behavioral data analysis. Mawhaw NJ: Lawerence-Erlbaum.
}
\examples{
Cliff_dependent_compute_from_table(movies)
}
\seealso{
[Cliff_dependent_compute_paired_d()]
}
