% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ireland.R
\name{Ireland_marginal_homogeneity}
\alias{Ireland_marginal_homogeneity}
\title{Fits marginal homogeneity model}
\usage{
Ireland_marginal_homogeneity(
  n,
  truncated = FALSE,
  max_iter = 15,
  verbose = FALSE
)
}
\arguments{
\item{n}{matrix of observed counts}

\item{truncated}{should the diagonal be excluded.  Default is FALSE, include the diagonal.}

\item{max_iter}{maximum number of iterations to perform}

\item{verbose}{should cycle-by-cycle information be printed out. Default is FALSE.}
}
\value{
a list containing
   mdis: value of the minimum discriminant information statistic (appox chi-squared)
   df: dgrees of freedom
   x_star: matrix of model-based counts
   p_star: matrix of model-based p-values
}
\description{
Fits the marginal homogeneity model according to the minimum discriminant information.
Ireland, C. T., Ku, H. H., & Kullback, S. (1969).  Symmetry and marginal homogeneity of
an r × r contingency table.  Journal of the American Statistical Association, 64(328),
1323-1341.
}
\examples{
Ireland_marginal_homogeneity(vision_data)
}
