% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Schuster.R
\name{Schuster_symmetric_rater_agreement_model}
\alias{Schuster_symmetric_rater_agreement_model}
\title{Computes the model that has kappa as a coefficient and symmetry.}
\usage{
Schuster_symmetric_rater_agreement_model(
  n,
  verbose = FALSE,
  max_iter = 10000,
  criterion = 1e-07,
  min_iter = 1000
)
}
\arguments{
\item{n}{the matrix of observed counts}

\item{verbose}{logical. should cycle-by-cycle information be printed out}

\item{max_iter}{integer. maximum number of iterations to perform}

\item{criterion}{number. maximum change in log(likelihood) to decide convergence}

\item{min_iter}{integer. minimum number of iterations to perform}
}
\value{
a list containing
   marginal_pi: vector of expected proportions for each category
   kappa numeric: kappa coefficient
   v: matrix of symmetry parameters
   chisq: Pearson X^2
   g_squared: likelihood ratio G^2
   df: degrees of freedom
}
\description{
Schuster, C. (2001). Kappa as a parameter of a symmetry model for rater agreement.
Journal of Educational and Behavioral Statistics, 26(3), 331-342.
}
