% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/originize_pkg.R
\name{originize_pkg}
\alias{originize_pkg}
\title{Originize a Package Project}
\usage{
originize_pkg(
  path = rstudioapi::getActiveProject(),
  pkgs = getOption("origin.pkgs", get_pkgs_from_description()),
  recursive = TRUE,
  exclude_files = NULL,
  overwrite = getOption("origin.overwrite", TRUE),
  ask_before_applying_changes = getOption("origin.ask_before_applying_changes", TRUE),
  check_conflicts = getOption("origin.check_conflicts", TRUE),
  check_base_conflicts = getOption("origin.check_base_conflicts", TRUE),
  add_base_packages = getOption("origin.add_base_packages", FALSE),
  excluded_functions = getOption("origin.excluded_functions", list()),
  verbose = getOption("origin.verbose", FALSE),
  use_markers = getOption("origin.use_markers_for_logging", TRUE),
  path_to_local_functions = getOption("origin.path_to_local_functions", NULL),
  check_local_conflicts = getOption("origin.check_local_conflicts", TRUE),
  filetypes = getOption("origin.filetypes", "R")
)
}
\arguments{
\item{path}{path to the package project root by
\link[rstudioapi]{getActiveProject}}

\item{pkgs}{a character vector of package names, defaults to packages
mentioned in the DESCRIPTION file if the option `origin.pkgs` is not set.}

\item{recursive}{logical. Should scripts be originized recursively, this
means that all files in the subfolders will be searched as well.
See \link[base]{list.files}}

\item{exclude_files}{a character vector of file paths that should be
excluded from being originized. Helpful if all but a few files should be
considered by origin.}

\item{overwrite}{if TRUE the file will be saved and overwritten. Otherwise,
only the logging is triggered. Note that, depending on
`ask_before_applying_changes`, the user is ask whether the result is
 as desired.}

\item{ask_before_applying_changes}{if TRUE, the user has to approve
changes made by origin prior to applying them. Note that this mutes all
checks, i.e. large number of files, local functions mask 
exported functions, and the presence and order of function conflicts.}

\item{check_conflicts}{if TRUE, possible namespace conflicts between
functions exported by packages listed in pkgs are checked. See details.}

\item{check_base_conflicts}{if TRUE; native R functions are also
included in checking for conflicts. See details.}

\item{add_base_packages}{a boolean. If TRUE, base R functions are handled
like all other packages and added via `::`}

\item{excluded_functions}{a list. Either an unnamed list of function names
as strings. These functions are excluded from all packages and never
considered in origin. Or a named list with character vectors, Then
the name of the list element refers to a package and the given functions
are only excluded from this package. A very explicit way to handle
namespace conflicts or highlighting popular infix functions like
`\%>\%` or `:=`.}

\item{verbose}{if TRUE, origin provides a logging output about its results.}

\item{use_markers}{a boolean. If TRUE, the markers tab inn RStudio is used
to track changes and show issues. FALSE prints the same information in
the console.}

\item{path_to_local_functions}{Path to search for local functions that mask
all exported functions from originizing. If NULL, defaults to the current
RStudio Project root.}

\item{check_local_conflicts}{if TRUE, it is checked whether locally
defined functions inside of the project mask exported functions
packages listed in pkgs. It avoids mistakenly adding pkg:: to a
custom local function.}

\item{filetypes}{which types of files to originize. 
Currently supported filetypes are .R, .RMD, .QMD. By default, R-files only
are considered.
Note: leading points are optional and upper/lower case are not considered.}
}
\value{
No return value, called for side effects
}
\description{
It shares the functionality of originize_dir but is designed to
 be used within R-package projects.
}
\details{
check_conflicts checks whether multiple packages listed in pkgs
export
functions with the same name, e.g. lag() is both part of the dplyr and
data.table namespace. If there are any conflicts actually present
in any considered script, these conflicts are shown including how origin
would solve them. User input is required to proceed. The order in pkgs
determines the precedence, while those listed first have higher precedence
than those listed later in the vector. This is consistent with function
masking in R.

check_base_conflicts checks whether functions listed in pkgs mask R functions
 of R core packages (base, utils, stats, methods, graphics, grDevices,
 datasets). Even tough the user might not include those functions in the
 pkg::fct logic, potential conflicts require careful evaluation.
}
\examples{
\dontrun{
originize_pkg(path = rstudioapi::getActiveProject(),
              overwrite = TRUE,
              ask_before_applying_changes = TRUE,
              exclude_files = c("dont_originize_this.R",
                                "dont_originize_that.R"),
              verbose = TRUE)
}
}
