% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bng.R
\name{BNGReference}
\alias{BNGReference}
\alias{[.BNGReference}
\alias{[[.BNGReference}
\alias{[<-.BNGReference}
\alias{[[<-.BNGReference}
\alias{c.BNGReference}
\alias{unique.BNGReference}
\alias{as.data.frame.BNGReference}
\title{BNG Reference objects}
\usage{
\method{[}{BNGReference}(x, i)

\method{[[}{BNGReference}(x, i)

\method{[}{BNGReference}(x, i) <- value

\method{[[}{BNGReference}(x, i) <- value

\method{c}{BNGReference}(...)

\method{unique}{BNGReference}(x, incomparables = FALSE, ...)

\method{as.data.frame}{BNGReference}(x, ...)
}
\arguments{
\item{x}{Object of class \code{BNGReference}.}

\item{i}{Record selection.}

\item{value}{A suitable replacement value of type \code{BNGReference}.}

\item{...}{Additional parameters.}

\item{incomparables}{A vector of values that cannot be compared. See
\code{\link[base]{unique}}.}
}
\value{
A vector of type \code{BNGReference}.
}
\description{
Functions to support working with objects of type
\code{BNGReference}.
}
\details{
The BNG is structured using a hierarchical system of grid squares at various
resolutions. At its highest level, the grid is divided into 100 km by 100 km
squares, each of which is identified by a two-letter code. Successive levels
of resolution further subdivide the grid squares into finer detail, down to
individual 1-meter squares.
}
\examples{
x <- as_bng_reference(c("TQ1234", "SU5678"))

x[1]

x[2] <- as_bng_reference("SU56")
x

}
\seealso{
\code{\link[=is_valid_bng]{is_valid_bng()}}, \code{\link[=as_bng_reference]{as_bng_reference()}}
}
