% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bng.R
\name{bng_to_geom}
\alias{bng_to_geom}
\title{Return the geometry of a British National Grid square}
\usage{
bng_to_geom(grid_ref, returnType = c("wkt", "geojson", "geos", "sf"))
}
\arguments{
\item{grid_ref}{(character) BNG grid reference (required).}

\item{returnType}{(character) Representation for the returned geometry.
Choose \code{'wkt'} or \code{'geojson'} to return the geometry in
Well-Known Text format or GeoJSON, respectively, \code{'geos'} to return an
object of class \code{geos} or \code{'sf'} for a Simple Features object of
class \code{sf}. Default is WKT format.}
}
\value{
The coordinates of the grid square boundary in either Well-Known
Text (WKT) format, GeoJSON format, an object of class \code{geos} or as a
Simple Features object of class \code{sf}.
}
\description{
Convert a valid British National Grid (BNG) grid reference string into a grid
square with the resolution implied by the length of the reference string.
}
\details{
The National Grid is a unique reference system that covers Great
Britain in a series of grid squares at multiple scales. Grid references
begin with 2 letters to identify 100km squares followed by a series of
digits to identify quadrants nested within. For more information, see
\url{https://www.ordnancesurvey.co.uk/documents/resources/guide-to-nationalgrid.pdf}

The purpose of this function is to generate geometries based on the extent
of the grid square which can be used as spatial filters in OS Data Hub API
queries.

Note that all geometries returned will have a coordinate reference system
(CRS) of a EPSG:27700. The \code{sf} package must be installed in order to
return an object of class \code{sf}.
}
\examples{
bng_to_geom('TL63')
bng_to_geom('TL683365', returnType = 'geojson')

}
\seealso{
\code{\link[=extent_from_bng]{extent_from_bng()}}
}
