% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osmdata-package.R
\docType{package}
\name{osmdata-package}
\alias{osmdata-package}
\title{Import OpenStreetMap data in 'sf', 'SC', 'sp', 'data.frame' and 'xml' formats}
\description{
Imports OpenStreetMap (OSM) data into R as 'sf', 'SC', 'sp', 'data.frame' or
'xml_document' objects. OSM data are extracted from the overpass API and
processed with very fast C++ routines for return to R. The package enables
simple overpass queries to be constructed without the user necessarily
understanding the syntax of the overpass query language, while retaining the
ability to handle arbitrarily complex queries. Functions are also provided to
enable recursive searching between different kinds of OSM data (for example,
to find all lines which intersect a given point).
}
\section{Functions to Prepare Queries}{

\itemize{
\item \link{getbb}: Get bounding box for a given place name
\item \link{bbox_to_string}: Convert a named matrix or a named vector
(or an unnamed vector) return a string
\item \link{overpass_status}: Retrieve status of the overpass API
\item \link{opq}: Build an overpass query
\item \link{add_osm_feature}: Add a feature to an overpass query
\item \link{opq_string}: Convert an osmdata query to overpass API
string
}
}

\section{Functions to Get Additional OSM Information}{

\itemize{
\item \link{available_features}: List recognised features in OSM
\item \link{available_tags}: List tags associated with a feature
}
}

\section{Functions to Extract OSM Data}{

\itemize{
\item \link{osmdata_data_frame}: Return OSM data in \code{\link{data.frame}}
format
\item \link{osmdata_sc}: Return OSM data in \pkg{silicate} format
\item \link{osmdata_sf}: Return OSM data in \pkg{sf} format
\item \link{osmdata_sp}: Return OSM data in \pkg{sp} format (DEPRECATED)
\item \link{osmdata_xml}: Return OSM data in \pkg{xml2} format
}
}

\section{Functions to Search Data}{

\itemize{
\item \code{osm_points}: Extract all \code{osm_points} objects
\item \code{osm_lines}: Extract all \code{osm_lines} objects
\item \code{osm_polygons}: Extract all \code{osm_polygons} objects
\item \code{osm_multilines}: Extract all \code{osm_multilines} objects
\item \code{osm_multipolygons}: Extract all \code{osm_multipolygons} objects
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://docs.ropensci.org/osmdata/}
  \item \url{https://github.com/ropensci/osmdata}
  \item Report bugs at \url{https://github.com/ropensci/osmdata/issues}
}

}
\author{
Joan Maspons, Mark Padgham, Bob Rudis, Robin Lovelace, Maëlle Salmon
}
\concept{package}
\keyword{internal}
