% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-osmdata-xml.R
\name{osmdata_xml}
\alias{osmdata_xml}
\title{Return an OSM Overpass query in XML format
Read an (XML format) OSM Overpass response from a string, a connection,
or a raw vector.}
\usage{
osmdata_xml(q, filename, quiet = TRUE, encoding)
}
\arguments{
\item{q}{An object of class \code{overpass_query} constructed with
\link{opq} and \link{add_osm_feature} or a string with a valid query, such
as \code{"(node(39.4712701,-0.3841326,39.4713799,-0.3839475);); out;"}. See examples below.}

\item{filename}{If given, OSM data are saved to the named file}

\item{quiet}{suppress status messages.}

\item{encoding}{Unless otherwise specified XML documents are assumed to be
encoded as UTF-8 or UTF-16. If the document is not UTF-8/16, and lacks
an explicit encoding directive, this allows you to supply a default.}
}
\value{
An object of class \code{xml2::xml_document} containing the result of the
overpass API query.
}
\description{
Return an OSM Overpass query in XML format
Read an (XML format) OSM Overpass response from a string, a connection,
or a raw vector.
}
\note{
Objects of class \code{xml_document} can be saved as \code{.xml} or
\code{.osm} files with \code{xml2::write_xml}.
}
\examples{
\dontrun{
query <- opq ("hampi india") |>
    add_osm_feature (key = "historic", value = "ruins")
# Then extract data from 'Overpass' API and save to local file:
osmdata_xml (query, filename = "hampi.osm")
}

# Complex query as a string (not possible with regular osmdata functions)
q <- '[out:xml][timeout:50];
    area[name="Països Catalans"][boundary=political]->.boundaryarea;

    rel(area.boundaryarea)[admin_level=8][boundary=administrative];
    map_to_area -> .all_level_8_areas;

    ( nwr(area.boundaryarea)[amenity=townhall]; >; );
    is_in;
    area._[admin_level=8][boundary=administrative] -> .level_8_areas_with_townhall;

    (.all_level_8_areas; - .level_8_areas_with_townhall;);
    rel(pivot);
    out tags;'

\dontrun{
no_townhall <- osmdata_xml (q)
no_townhall
}
}
\seealso{
Other extract: 
\code{\link{osmdata_data_frame}()},
\code{\link{osmdata_sc}()},
\code{\link{osmdata_sf}()},
\code{\link{osmdata_sp}()}
}
\concept{extract}
