% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/depMapQuery.R
\name{depMapQuery}
\alias{depMapQuery}
\title{Retrieve DepMap Essentiality data for a specified gene.}
\usage{
depMapQuery(ensgId)
}
\arguments{
\item{ensgId}{Character: ENSEMBL ID of the target gene (e.g., ENSG00000141510).}
}
\value{
Returns a tibble containing DepMap essentiality data for the specified gene.
}
\description{
This function queries the Open Targets GraphQL API to retrieve DepMap essentiality data
for a specified gene.
}
\examples{
\dontrun{
result <- depMapQuery(ensgId = "ENSG00000141510")
}
}
