% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomicsEnglandQuery.R
\name{genomicsEnglandQuery}
\alias{genomicsEnglandQuery}
\title{Retrieve Genomics England data for a specified gene and disease.}
\usage{
genomicsEnglandQuery(ensemblId, efoId, size = 3500)
}
\arguments{
\item{ensemblId}{Character: ENSEMBL ID of the target gene (e.g., "ENSG00000080815").}

\item{efoId}{Character: EFO ID of the target disease (e.g., "MONDO_0004975").}

\item{size}{Integer: Number of records to retrieve (default: 3500).}
}
\value{
Returns a tibble containing Genomics England evidence data for the specified gene and disease.
}
\description{
This function queries the Open Targets GraphQL API to retrieve Genomics England evidence data
for a specified gene and disease.
}
\examples{
\dontrun{
result <- genomicsEnglandQuery(ensemblId = "ENSG00000080815", efoId = 
"MONDO_0004975", size = 3500)
}
}
