% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ombc_gmm.R
\name{get_init_z}
\alias{get_init_z}
\title{Obtain an initial clustering as a component assignment matrix.}
\usage{
get_init_z(
  comp_num,
  dist_mat = NULL,
  x = NULL,
  init_method = c("hc", "kmpp"),
  kmpp_seed = NULL
)
}
\arguments{
\item{comp_num}{Number of mixture components.}

\item{dist_mat}{Euclidean distance matrix.}

\item{x}{Data.}

\item{init_method}{Method used to initialise each mixture model.}

\item{kmpp_seed}{Optional seed for k-means++ initialisation.}
}
\value{
A component assignment matrix for initialisation.
}
\description{
Implement the specified initial clustering, either hierarchical
clustering or k-means++, and return a binary component assignment matrix.
}
