% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcomp_bayes.R
\name{calc_gcomp_ml}
\alias{calc_gcomp_ml}
\title{G-computation Maximum Likelihood Bootstrap}
\usage{
calc_gcomp_ml(strategy, analysis_params)
}
\arguments{
\item{strategy}{A list specifying the model strategy, including:
\itemize{
\item \code{R}: Number of bootstrap replications.
\item \code{formula}: A linear regression \code{formula} object.
\item \code{family}: A \code{family} object specifying the distribution and link function
(e.g., \code{binomial}).
\item \code{N}: Synthetic sample size for g-computation.
}}

\item{analysis_params}{List of analysis parameters.}
}
\value{
A list containing:
\itemize{
\item \code{means}: A list containing:
\itemize{
\item \code{A}: Bootstrap estimates for comparator treatment group "A".
\item \code{C}: Bootstrap estimates for reference treatment group "C".
}
\item \code{model}: A list containing the \code{fit} object, \code{rho}, and \code{N}.
}
}
\description{
Computes the mean difference in treatment effects using bootstrap resampling.
}
\examples{
strategy <- list(
  formula = y ~ trt:X1,
  family = binomial(),
  rho = NA,
  N = 1000L,
  n_boot = 100L,
  marginal_distns = NA,
  marginal_params = NA,
  trt_var = "trt")

ipd <- data.frame(trt = sample(c("A", "C"), size = 100, replace = TRUE),
                  X1 = rnorm(100, 1, 1),
                  y = sample(c(1,0), size = 100, prob = c(0.7,0.3), replace = TRUE))

ald <- data.frame(trt = c(NA, NA, "B", "C", "B", "C"),
                  variable = c("X1", "X1", "y", "y", NA, NA),
                  statistic = c("mean", "sd", "sum", "sum", "N", "N"),
                  value = c(0.5, 0.1, 10, 12, 20, 25))

calc_gcomp_ml(
  strategy,
  analysis_params = 
    list(ipd = ipd, ald = ald, 
         ref_trt = "C", 
         ipd_comp = "A"))
         
}
