% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_ate.R
\name{calculate_trial_variance}
\alias{calculate_trial_variance}
\title{Calculate trial variance}
\usage{
calculate_trial_variance(ald, tid, effect, family)
}
\arguments{
\item{ald}{Aggregate-level data. Data frame.}

\item{tid}{Treatment identifier used to extract relevant columns from \code{ald}.}

\item{effect}{A character string specifying the effect scale (e.g., "log_odds", "risk_difference").}

\item{family}{A character string specifying the model family (e.g., "binomial", "gaussian").}
}
\value{
Numeric computed variance of treatment effects.
}
\description{
Computes the variance of treatment effects for a trial based on the specified family distribution.
}
\examples{
ald <- data.frame(trt = c("B","C","B","C"),
                  variable = c(NA, NA, "y", "y"),
                  statistic = c("N", "N", "sum", "sum"),
                  value = c(100, 100, 50, 60))
                  
calculate_trial_variance(
  ald, tid = "B", effect = "log_odds", family = "binomial")
  
}
