% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_ate.R
\name{get_treatment_effect}
\alias{get_treatment_effect}
\title{Get treatment effect scale corresponding to a link function}
\usage{
get_treatment_effect(link)
}
\arguments{
\item{link}{A character string specifying the link function. Options are:
\describe{
\item{"logit"}{Log-odds scale.}
\item{"identity"}{Risk difference.}
\item{"probit"}{Probit scale.}
\item{"cloglog"}{Log relative risk for rare events.}
\item{"log"}{Log relative risk.}
}}
}
\value{
A character string representing the treatment effect scale.
}
\description{
Maps a given link function to its corresponding treatment effect scale.
}
\examples{
 get_treatment_effect(link = "logit")
 get_treatment_effect(link = "identity")
 
}
