% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customers.R
\name{paddle_create_customer_business}
\alias{paddle_create_customer_business}
\title{Create a Business for a Customer}
\usage{
paddle_create_customer_business(
  id,
  name,
  company_number = NULL,
  tax_identifier = NULL,
  contacts = NULL,
  custom_data = NULL
)
}
\arguments{
\item{id}{Character. Paddle customer ID (e.g., "ctm_123"). Required.}

\item{name}{Character. Name of the business. Required.}

\item{company_number}{Character. Optional company number.}

\item{tax_identifier}{Character. Optional tax/VAT ID.}

\item{contacts}{List of contact objects (each a named list with `"name"` and required `"email"`). Optional.}

\item{custom_data}{Named list of additional custom fields. Optional.}
}
\value{
A list containing the created business entity and metadata.
}
\description{
Creates a new business entity associated with a specific customer in the Paddle API.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
result <- paddle_create_customer_business(
  id = "ctm_123",
  name = "Acme Inc.",
  tax_identifier = "123456789",
  contacts = list(list(email = "ceo@acme.com") )
)
\dontshow{\}) # examplesIf}
}
