% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transactions.R
\name{paddle_list_transactions}
\alias{paddle_list_transactions}
\title{List Paddle Transactions}
\usage{
paddle_list_transactions(
  after = NULL,
  id = NULL,
  customer_id = NULL,
  subscription_id = NULL,
  invoice_number = NULL,
  origin = NULL,
  status = NULL,
  collection_mode = NULL,
  billed_at = NULL,
  created_at = NULL,
  updated_at = NULL,
  order_by = NULL,
  include = NULL,
  per_page = NULL
)
}
\arguments{
\item{after}{Character. Paddle ID cursor for pagination. Optional.}

\item{id}{Character vector of transaction IDs. Optional.}

\item{customer_id}{Character vector of customer IDs. Optional.}

\item{subscription_id}{Character vector of subscription IDs or `"null"` to fetch unlinked. Optional.}

\item{invoice_number}{Character vector of invoice numbers. Optional.}

\item{origin}{Character vector of origins. Optional.}

\item{status}{Character vector of statuses. Must be one of `"draft"`, `"ready"`, `"billed"`, `"paid"`, `"completed"`, `"canceled"`, `"past_due"`. Optional.}

\item{collection_mode}{Character. Must be one of `"automatic"` or `"manual"`. Optional.}

\item{billed_at}{Character. RFC 3339 datetime or filter (e.g., "billed_at[LT]=2023-01-01T00:00:00Z"). Optional.}

\item{created_at}{Character. Same format as billed_at. Optional.}

\item{updated_at}{Character. Same format as billed_at. Optional.}

\item{order_by}{Character. Must be one of `billed_at[ASC|DESC]`, `created_at[ASC|DESC]`, `id[ASC|DESC]`, `updated_at[ASC|DESC]`. Optional.}

\item{include}{Character vector. Must be one of `"address"`, `"adjustments"`, `"adjustments_totals"`, `"available_payment_methods"`, `"business"`, `"customer"`, `"discount"`. Optional.}

\item{per_page}{Integer. Max results per page (max 200). Optional.}
}
\value{
A list containing transactions and pagination metadata.
}
\description{
Retrieves a paginated list of transactions from the Paddle API.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_list_transactions()
\dontshow{\}) # examplesIf}
}
