% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discounts.R
\name{paddle_update_discount}
\alias{paddle_update_discount}
\title{Update a Paddle Discount}
\usage{
paddle_update_discount(
  id,
  status = NULL,
  description = NULL,
  enabled_for_checkout = NULL,
  code = NULL,
  type = NULL,
  mode = NULL,
  amount = NULL,
  currency_code = NULL,
  recur = NULL,
  maximum_recurring_intervals = NULL,
  usage_limit = NULL,
  restrict_to = NULL,
  expires_at = NULL,
  custom_data = NULL
)
}
\arguments{
\item{id}{Character. The Paddle discount ID (e.g., "dsc_123"). Required.}

\item{status}{Character vector of discount statuses (one of `"active"`, `"archived"`). Optional.}

\item{description}{Character. Internal description. Optional.}

\item{enabled_for_checkout}{Logical. Available for checkout? Optional.}

\item{code}{Character. Discount code. Optional.}

\item{type}{Character. Type of discount (`"percentage"`, `"flat"`, or `"flat_per_seat"`). Optional.}

\item{mode}{Character. Filter discounts by mode (one of `"standard"`, `"custom"`). Optional.}

\item{amount}{Character. Discount amount. Optional.}

\item{currency_code}{Character. Required for "flat"/"flat_per_seat". Optional.}

\item{recur}{Logical. Repeating discount? Optional.}

\item{maximum_recurring_intervals}{Integer. Number of repeats. Optional.}

\item{usage_limit}{Integer. Max redemptions. Optional.}

\item{restrict_to}{Character vector. Product or price IDs. Optional.}

\item{expires_at}{Character. RFC 3339 datetime string. Optional.}

\item{custom_data}{Named list. Custom metadata. Optional.}
}
\value{
A list containing the updated discount and metadata.
}
\description{
Updates an existing discount by ID via the Paddle API.
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_update_discount(
  id = "dsc_123",
  description = "Updated description")
\dontshow{\}) # examplesIf}
}
