% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemini_batch_api.R
\name{build_gemini_batch_requests}
\alias{build_gemini_batch_requests}
\title{Build Gemini batch requests from a tibble of pairs}
\usage{
build_gemini_batch_requests(
  pairs,
  model,
  trait_name,
  trait_description,
  prompt_template = set_prompt_template(),
  thinking_level = c("low", "medium", "high"),
  custom_id_prefix = "GEM",
  temperature = NULL,
  top_p = NULL,
  top_k = NULL,
  max_output_tokens = NULL,
  include_thoughts = FALSE,
  ...
)
}
\arguments{
\item{pairs}{Tibble or data frame with at least columns \code{ID1},
\code{text1}, \code{ID2}, \code{text2}. Typically created by
\code{\link{make_pairs}}, \code{\link{sample_pairs}}, and
\code{\link{randomize_pair_order}}.}

\item{model}{Gemini model name, for example \code{"gemini-3-pro-preview"}.
This parameter is not embedded in each request object (the model is
provided via the path), but is included here for symmetry with other
backends and potential validation.}

\item{trait_name}{Short label for the trait (for example "Overall Quality").}

\item{trait_description}{Full-text description of the trait or rubric.}

\item{prompt_template}{Prompt template string, typically from
\code{\link{set_prompt_template}}. The template should embed your full
instructions, rubric text, and \verb{<BETTER_SAMPLE>} tagging convention.}

\item{thinking_level}{One of \code{"low"}, \code{"medium"}, or \code{"high"}.
This is mapped to Gemini's \code{thinkingConfig.thinkingLevel}, where
\code{"low"} maps to "Low" and both \code{"medium"} and \code{"high"} map
to "High". "Medium" currently behaves like "High".}

\item{custom_id_prefix}{Prefix for the \code{custom_id} field. Defaults to
\code{"GEM"} so that IDs take the form \code{"GEM_<ID1>_vs_<ID2>"}.}

\item{temperature}{Optional numeric temperature. If \code{NULL}, it is
omitted and Gemini uses its own default.}

\item{top_p}{Optional nucleus sampling parameter. If \code{NULL}, omitted.}

\item{top_k}{Optional top-k sampling parameter. If \code{NULL}, omitted.}

\item{max_output_tokens}{Optional integer. If \code{NULL}, omitted.}

\item{include_thoughts}{Logical; if \code{TRUE}, sets
\code{thinkingConfig.includeThoughts = TRUE} so that Gemini returns
visible chain-of-thought. For most pairwise scoring use cases this should
remain \code{FALSE}.}

\item{...}{Reserved for future extensions. Any \code{thinking_budget}
entries are ignored (Gemini 3 Pro does not support thinking budgets).}
}
\value{
A tibble with one row per pair and two main columns:
\describe{
\item{custom_id}{Character ID of the form
\code{"<PREFIX>_<ID1>_vs_<ID2>"}.}
\item{request}{List-column containing the Gemini GenerateContent request
object for each pair.}
}
}
\description{
This helper converts a tibble of writing pairs into a set of Gemini
GenerateContent requests suitable for use with the Batch API
(\code{models/*:batchGenerateContent}).
}
\details{
Each pair receives a unique \code{custom_id} of the form
\code{"GEM_<ID1>_vs_<ID2>"} and a corresponding request object containing
the prompt and generation configuration.
}
\examples{
data("example_writing_samples", package = "pairwiseLLM")

pairs <- example_writing_samples |>
  make_pairs() |>
  sample_pairs(n_pairs = 3, seed = 123) |>
  randomize_pair_order(seed = 456)

td <- trait_description("overall_quality")
tmpl <- set_prompt_template()

reqs <- build_gemini_batch_requests(
  pairs             = pairs,
  model             = "gemini-3-pro-preview",
  trait_name        = td$name,
  trait_description = td$description,
  prompt_template   = tmpl,
  thinking_level    = "low",
  include_thoughts  = TRUE
)

reqs

}
