% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pbdb_taxonomic_functions.R
\name{pbdb_subtaxa}
\alias{pbdb_subtaxa}
\title{Count number of taxa in an occurrence data frame}
\usage{
pbdb_subtaxa(data, do_plot = TRUE, col = "#0000FF")
}
\arguments{
\item{data}{Data frame from a query to PaleobioDB as returned by
the \code{\link[=pbdb_occurrences]{pbdb_occurrences()}} function using the argument \code{show = "class"} or \code{show = "classext"}.}

\item{do_plot}{Logical indicating whether to produce a plot (\code{TRUE}
by default).}

\item{col}{Colour of the histogram.}
}
\value{
A data frame with the number of subtaxa in the data.
}
\description{
Count the number of taxa (species, genera, families, orders,
classes, and phyla) in an occurrence data frame.
}
\examples{
\dontrun{
  canidae_quat <- pbdb_occurrences(
    limit = "all", base_name = "Canidae",  interval = "Quaternary",
    show = c("coords", "classext", "ident"), vocab = "pbdb"
  )
  pbdb_subtaxa(canidae_quat)
}
}
