% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{pal.heatmap2}
\alias{pal.heatmap2}
\title{Show palettes/colormaps with comparison heatmaps}
\usage{
pal.heatmap2(..., n = 100, nc = 6, nr = 20, labels = NULL)
}
\arguments{
\item{...}{Palettes/colormaps, each of which is either
(1) a vectors of colors or
(2) a function returning a vector of colors.}

\item{n}{The number of colors to display for palette functions.}

\item{nc}{The number of columns in each color block.}

\item{nr}{The number of rows in each color block.}

\item{labels}{Vector of labels for palettes}
}
\value{
None
}
\description{
Draw a heatmap for each palette. Each palette heatmap consists
of a block of randomly-chosen colors, plus a block for each
color with random substitutions of the other colors.
A missing value NA is added to each palette of colors.
}
\examples{
pal.heatmap2(watlington(16), tol.groundcover(14), brewer.rdylbu(11),
  nc=6, nr=20,
  labels=c("watlington","tol.groundcover","brewer.rdylbu"))
}
\references{
None
}
\author{
Kevin Wright
}
