% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_data.R
\name{gen_data}
\alias{gen_data}
\title{Generate data through a factor matrix and effects matrix.}
\usage{
gen_data(factor_struct, effects_struct, n_cases = 1000, true_scores = FALSE)
}
\arguments{
\item{factor_struct}{A matrix describing the measurement model of latent
factors (columns) as measured by observed variables (rows).}

\item{effects_struct}{A matrix describing the variances and covariances of
the latent variables in the model.}

\item{n_cases}{Number of sample cases to generate.}

\item{true_scores}{Whether or not to include the data for each variable as
measured without error. If set to TRUE, the resulting data frame will
include all the variables in the model twice: once with measurement error,
and once without.}
}
\value{
Returns a data frame with \code{n_cases} rows and columns for each
  observed and latent variable. These variables will approximately accord
  with the factor structure and effects structure that was specified, within
  sampling error.
}
\description{
\code{gen_data} will generate sample data based on a factor structure and
effects structure specified by the user.
}
\examples{
# two uncorrelated predictors, one criterion, with measurement error in all
# variables
beta1 <- .5
beta2 <- .6
y_resid_var <- sqrt(1 - (beta1^2 + beta2^2))
fmodel <- matrix(
    c(.8, 0, 0,   # x1
      0, .6, 0,   # x2
      0, 0, .5),  # y
    nrow=3, ncol=3, byrow=TRUE, dimnames=list(
    c('x1', 'x2', 'y'), c('x1', 'x2', 'y')))
    # in this case, observed and latent variables are the same
effects <- matrix(
    c(1, 0, beta1,
      0, 1, beta2,
      0, 0, y_resid_var),
    nrow=3, ncol=3, byrow=TRUE, dimnames=list(
    c('x1', 'x2', 'y'), c('x1', 'x2', 'y')))

sample_data <- gen_data(fmodel, effects, n_cases=1000)
round(var(sample_data), 2)
round(cor(sample_data), 2)
summary(lm(y ~ x1 + x2, data=sample_data))
    # note that beta coefficients are much smaller, due to measurement error
}
