% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genesis.R
\name{genesis}
\alias{genesis}
\alias{phyllotactic_genesis}
\alias{predefined_genesis}
\alias{bigbang_genesis}
\alias{aquarium_genesis}
\alias{petridish_genesis}
\title{Particle initialisation}
\usage{
phyllotactic_genesis(radius = 10, angle = pi * (3 - sqrt(5)))

predefined_genesis(x, y, x_vel = 0, y_vel = 0)

bigbang_genesis(vel_min = 0, vel_max = 1)

aquarium_genesis(width = 10, height = 10, vel_min = 0, vel_max = 1)

petridish_genesis(max_radius = 10, vel_min = 0, vel_max = 1)
}
\arguments{
\item{radius}{The radius modifier (will be multiplied by the square root of the index of the particle)}

\item{angle}{The angular difference between two adjacent particles}

\item{x, y}{The columns holding (or value of) the position coordinates}

\item{x_vel, y_vel}{The columns holding (or value of) the velocity verlets}

\item{vel_min, vel_max}{The bounds of the uniformly distributed velocities}

\item{width, height}{The size of the rectangle holding the particles}

\item{max_radius}{The size of the disc.}
}
\value{
A function that takes the particle graph and returns a list with a
position and velocity element, each holding a matrix with two columns and a
row for each particle giving the x and y position and velocity respectively.
}
\description{
These functions are passed to the simulation and defines how the position and
velocity of the particles are initiated. The default is to lay out the nodes
in a phyllotactic arrangement (think sunflower seeds) and with no velocity,
which is also the default in d3-force.
}
\section{Functions}{
\itemize{
\item \code{phyllotactic_genesis()}: Initiates particles in a phyllotactic arrangement with zero velocity

\item \code{predefined_genesis()}: Uses information from the node data to set position and velocity.

\item \code{bigbang_genesis()}: Initiates particles at center position and a random velocity

\item \code{aquarium_genesis()}: Places particles randomly in a rectangle and gives them a random velocity

\item \code{petridish_genesis()}: Places particles randomly on a disc and gives them a random velocity

}}
\examples{
# A contrieved example
graph <- tidygraph::create_notable('bull')
genesis <- phyllotactic_genesis()
genesis(graph)

# Usually used as an argument to simulate
graph |>
  simulate(setup = phyllotactic_genesis())

}
