% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delta_downscale.R
\name{delta_downscale}
\alias{delta_downscale}
\title{Downscale using the delta method}
\usage{
delta_downscale(
  x,
  delta_rast,
  x_landmask_high = NULL,
  range_limits = NULL,
  nmax = 7,
  set = list(idp = 0.5),
  ...
)
}
\arguments{
\item{x}{a \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} for the variable of interest, with all
time steps of interest}

\item{delta_rast}{a \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} generated by
\code{pastclim::delta_compute}}

\item{x_landmask_high}{a \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} with the same number of layers
as x. If left NULL, the original landmask of x is used.}

\item{range_limits}{range to which the downscaled reconstructions
are forced to be within (usually based on the observed values). Ignored if
left to NULL.}

\item{nmax}{the number of nearest observations that should be used for a
kriging prediction or simulation, where nearest is defined in terms
of the space of the spatial locations (see \code{\link[gstat:gstat]{gstat::gstat()}} for details)}

\item{set}{named list with optional parameters to be passed to gstat
(only set commands of gstat are allowed, and not all of them may be
relevant; see the gstat manual for gstat stand-alone, URL and more details
in the \code{\link[gstat:gstat]{gstat::gstat()}} help page)}

\item{...}{further parameters to be passed to \code{\link[gstat:gstat]{gstat::gstat()}}}
}
\value{
a \code{\link[terra:SpatRaster-class]{terra::SpatRaster}} of the downscaled variable, where each
layers is a time step.
}
\description{
The delta method computes the difference between an observed raster and the
equivalent predictions from a model for a given time step, and then applies
that difference (delta) to all other time steps. You will first need to
create the delta raster with \code{\link[=delta_compute]{delta_compute()}}, and thus use it
as an argument for this function.
}
\details{
It is possible to also provide a high resolution landmask to this function.
For cells which are not included in the original simulation (e.g. because
the landmask was discretised at lower resolution), an inverse
distance weighted algorithm (as implemented in \code{\link[gstat:gstat]{gstat::gstat()}}) is used
to interpolate the missing values. See the manpage for \code{\link[gstat:gstat]{gstat::gstat()}}
for more parameters that can change the behaviour of the iwd interpolation.
}
