% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interfaces.R
\name{distanceMetric}
\alias{distanceMetric}
\alias{distanceMetric.default}
\title{Distance Metric Interface}
\usage{
distanceMetric(x, method = "euclidean", ...)

\method{distanceMetric}{default}(x, method = "euclidean", ...)
}
\arguments{
\item{x}{Input data matrix or vector}

\item{method}{Either a character string specifying built-in method ("euclidean", "manhattan", "maximum") or a custom function}

\item{...}{Additional arguments passed to methods}
}
\value{
A distance object or matrix containing pairwise distances
}
\description{
A generic interface for computing distances between observations
using either built-in or custom distance metrics.
}
\details{
Generic Interface for Distance Metrics
}
\section{Methods (by class)}{
\itemize{
\item \code{distanceMetric(default)}: Default method for built-in metrics

}}
\examples{
# Using built-in method
x <- matrix(rnorm(100), ncol=2)
d1 <- distanceMetric(x, "euclidean")

# Using custom method
custom_dist <- function(x) as.dist(crossprod(t(x)))
d2 <- distanceMetric(x, method=custom_dist)
}
