# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include kafka_service.R
NULL

#' Associates one or more Scram Secrets with an Amazon MSK cluster
#'
#' @description
#' Associates one or more Scram Secrets with an Amazon MSK cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_batch_associate_scram_secret/](https://www.paws-r-sdk.com/docs/kafka_batch_associate_scram_secret/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) of the cluster to be updated.
#' @param SecretArnList &#91;required&#93; List of AWS Secrets Manager secret ARNs.
#'
#' @keywords internal
#'
#' @rdname kafka_batch_associate_scram_secret
kafka_batch_associate_scram_secret <- function(ClusterArn, SecretArnList) {
  op <- new_operation(
    name = "BatchAssociateScramSecret",
    http_method = "POST",
    http_path = "/v1/clusters/{clusterArn}/scram-secrets",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$batch_associate_scram_secret_input(ClusterArn = ClusterArn, SecretArnList = SecretArnList)
  output <- .kafka$batch_associate_scram_secret_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$batch_associate_scram_secret <- kafka_batch_associate_scram_secret

#' Creates a new MSK cluster
#'
#' @description
#' Creates a new MSK cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_create_cluster/](https://www.paws-r-sdk.com/docs/kafka_create_cluster/) for full documentation.
#'
#' @param BrokerNodeGroupInfo &#91;required&#93; Information about the broker nodes in the cluster.
#' @param ClientAuthentication Includes all client authentication related information.
#' @param ClusterName &#91;required&#93; The name of the cluster.
#' @param ConfigurationInfo Represents the configuration that you want MSK to use for the brokers in
#' a cluster.
#' @param EncryptionInfo Includes all encryption-related information.
#' @param EnhancedMonitoring Specifies the level of monitoring for the MSK cluster. The possible
#' values are DEFAULT, PER_BROKER, PER_TOPIC_PER_BROKER, and
#' PER_TOPIC_PER_PARTITION.
#' @param OpenMonitoring The settings for open monitoring.
#' @param KafkaVersion &#91;required&#93; The version of Apache Kafka.
#' @param LoggingInfo 
#' @param NumberOfBrokerNodes &#91;required&#93; The number of broker nodes in the cluster.
#' @param Tags Create tags when creating the cluster.
#' @param StorageMode This controls storage mode for supported storage tiers.
#'
#' @keywords internal
#'
#' @rdname kafka_create_cluster
kafka_create_cluster <- function(BrokerNodeGroupInfo, ClientAuthentication = NULL, ClusterName, ConfigurationInfo = NULL, EncryptionInfo = NULL, EnhancedMonitoring = NULL, OpenMonitoring = NULL, KafkaVersion, LoggingInfo = NULL, NumberOfBrokerNodes, Tags = NULL, StorageMode = NULL) {
  op <- new_operation(
    name = "CreateCluster",
    http_method = "POST",
    http_path = "/v1/clusters",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$create_cluster_input(BrokerNodeGroupInfo = BrokerNodeGroupInfo, ClientAuthentication = ClientAuthentication, ClusterName = ClusterName, ConfigurationInfo = ConfigurationInfo, EncryptionInfo = EncryptionInfo, EnhancedMonitoring = EnhancedMonitoring, OpenMonitoring = OpenMonitoring, KafkaVersion = KafkaVersion, LoggingInfo = LoggingInfo, NumberOfBrokerNodes = NumberOfBrokerNodes, Tags = Tags, StorageMode = StorageMode)
  output <- .kafka$create_cluster_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$create_cluster <- kafka_create_cluster

#' Creates a new MSK cluster
#'
#' @description
#' Creates a new MSK cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_create_cluster_v2/](https://www.paws-r-sdk.com/docs/kafka_create_cluster_v2/) for full documentation.
#'
#' @param ClusterName &#91;required&#93; The name of the cluster.
#' @param Tags A map of tags that you want the cluster to have.
#' @param Provisioned Information about the provisioned cluster.
#' @param Serverless Information about the serverless cluster.
#'
#' @keywords internal
#'
#' @rdname kafka_create_cluster_v2
kafka_create_cluster_v2 <- function(ClusterName, Tags = NULL, Provisioned = NULL, Serverless = NULL) {
  op <- new_operation(
    name = "CreateClusterV2",
    http_method = "POST",
    http_path = "/api/v2/clusters",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$create_cluster_v2_input(ClusterName = ClusterName, Tags = Tags, Provisioned = Provisioned, Serverless = Serverless)
  output <- .kafka$create_cluster_v2_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$create_cluster_v2 <- kafka_create_cluster_v2

#' Creates a new MSK configuration
#'
#' @description
#' Creates a new MSK configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_create_configuration/](https://www.paws-r-sdk.com/docs/kafka_create_configuration/) for full documentation.
#'
#' @param Description The description of the configuration.
#' @param KafkaVersions The versions of Apache Kafka with which you can use this MSK
#' configuration.
#' @param Name &#91;required&#93; The name of the configuration.
#' @param ServerProperties &#91;required&#93; Contents of the server.properties file. When using the API, you must
#' ensure that the contents of the file are base64 encoded. When using the
#' AWS Management Console, the SDK, or the AWS CLI, the contents of
#' server.properties can be in plaintext.
#'
#' @keywords internal
#'
#' @rdname kafka_create_configuration
kafka_create_configuration <- function(Description = NULL, KafkaVersions = NULL, Name, ServerProperties) {
  op <- new_operation(
    name = "CreateConfiguration",
    http_method = "POST",
    http_path = "/v1/configurations",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$create_configuration_input(Description = Description, KafkaVersions = KafkaVersions, Name = Name, ServerProperties = ServerProperties)
  output <- .kafka$create_configuration_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$create_configuration <- kafka_create_configuration

#' Creates the replicator
#'
#' @description
#' Creates the replicator.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_create_replicator/](https://www.paws-r-sdk.com/docs/kafka_create_replicator/) for full documentation.
#'
#' @param Description A summary description of the replicator.
#' @param KafkaClusters &#91;required&#93; Kafka Clusters to use in setting up sources / targets for replication.
#' @param ReplicationInfoList &#91;required&#93; A list of replication configurations, where each configuration targets a
#' given source cluster to target cluster replication flow.
#' @param ReplicatorName &#91;required&#93; The name of the replicator. Alpha-numeric characters with '-' are
#' allowed.
#' @param ServiceExecutionRoleArn &#91;required&#93; The ARN of the IAM role used by the replicator to access resources in
#' the customer's account (e.g source and target clusters)
#' @param Tags List of tags to attach to created Replicator.
#'
#' @keywords internal
#'
#' @rdname kafka_create_replicator
kafka_create_replicator <- function(Description = NULL, KafkaClusters, ReplicationInfoList, ReplicatorName, ServiceExecutionRoleArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateReplicator",
    http_method = "POST",
    http_path = "/replication/v1/replicators",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$create_replicator_input(Description = Description, KafkaClusters = KafkaClusters, ReplicationInfoList = ReplicationInfoList, ReplicatorName = ReplicatorName, ServiceExecutionRoleArn = ServiceExecutionRoleArn, Tags = Tags)
  output <- .kafka$create_replicator_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$create_replicator <- kafka_create_replicator

#' Creates a new MSK VPC connection
#'
#' @description
#' Creates a new MSK VPC connection.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_create_vpc_connection/](https://www.paws-r-sdk.com/docs/kafka_create_vpc_connection/) for full documentation.
#'
#' @param TargetClusterArn &#91;required&#93; The cluster Amazon Resource Name (ARN) for the VPC connection.
#' @param Authentication &#91;required&#93; The authentication type of VPC connection.
#' @param VpcId &#91;required&#93; The VPC ID of VPC connection.
#' @param ClientSubnets &#91;required&#93; The list of client subnets.
#' @param SecurityGroups &#91;required&#93; The list of security groups.
#' @param Tags A map of tags for the VPC connection.
#'
#' @keywords internal
#'
#' @rdname kafka_create_vpc_connection
kafka_create_vpc_connection <- function(TargetClusterArn, Authentication, VpcId, ClientSubnets, SecurityGroups, Tags = NULL) {
  op <- new_operation(
    name = "CreateVpcConnection",
    http_method = "POST",
    http_path = "/v1/vpc-connection",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$create_vpc_connection_input(TargetClusterArn = TargetClusterArn, Authentication = Authentication, VpcId = VpcId, ClientSubnets = ClientSubnets, SecurityGroups = SecurityGroups, Tags = Tags)
  output <- .kafka$create_vpc_connection_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$create_vpc_connection <- kafka_create_vpc_connection

#' Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in
#' the request
#'
#' @description
#' Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_delete_cluster/](https://www.paws-r-sdk.com/docs/kafka_delete_cluster/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#' @param CurrentVersion The current version of the MSK cluster.
#'
#' @keywords internal
#'
#' @rdname kafka_delete_cluster
kafka_delete_cluster <- function(ClusterArn, CurrentVersion = NULL) {
  op <- new_operation(
    name = "DeleteCluster",
    http_method = "DELETE",
    http_path = "/v1/clusters/{clusterArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$delete_cluster_input(ClusterArn = ClusterArn, CurrentVersion = CurrentVersion)
  output <- .kafka$delete_cluster_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$delete_cluster <- kafka_delete_cluster

#' Deletes the MSK cluster policy specified by the Amazon Resource Name
#' (ARN) in the request
#'
#' @description
#' Deletes the MSK cluster policy specified by the Amazon Resource Name (ARN) in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_delete_cluster_policy/](https://www.paws-r-sdk.com/docs/kafka_delete_cluster_policy/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) of the cluster.
#'
#' @keywords internal
#'
#' @rdname kafka_delete_cluster_policy
kafka_delete_cluster_policy <- function(ClusterArn) {
  op <- new_operation(
    name = "DeleteClusterPolicy",
    http_method = "DELETE",
    http_path = "/v1/clusters/{clusterArn}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$delete_cluster_policy_input(ClusterArn = ClusterArn)
  output <- .kafka$delete_cluster_policy_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$delete_cluster_policy <- kafka_delete_cluster_policy

#' Deletes an MSK Configuration
#'
#' @description
#' Deletes an MSK Configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_delete_configuration/](https://www.paws-r-sdk.com/docs/kafka_delete_configuration/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies an MSK
#' configuration.
#'
#' @keywords internal
#'
#' @rdname kafka_delete_configuration
kafka_delete_configuration <- function(Arn) {
  op <- new_operation(
    name = "DeleteConfiguration",
    http_method = "DELETE",
    http_path = "/v1/configurations/{arn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$delete_configuration_input(Arn = Arn)
  output <- .kafka$delete_configuration_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$delete_configuration <- kafka_delete_configuration

#' Deletes a replicator
#'
#' @description
#' Deletes a replicator.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_delete_replicator/](https://www.paws-r-sdk.com/docs/kafka_delete_replicator/) for full documentation.
#'
#' @param CurrentVersion The current version of the replicator.
#' @param ReplicatorArn &#91;required&#93; The Amazon Resource Name (ARN) of the replicator to be deleted.
#'
#' @keywords internal
#'
#' @rdname kafka_delete_replicator
kafka_delete_replicator <- function(CurrentVersion = NULL, ReplicatorArn) {
  op <- new_operation(
    name = "DeleteReplicator",
    http_method = "DELETE",
    http_path = "/replication/v1/replicators/{replicatorArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$delete_replicator_input(CurrentVersion = CurrentVersion, ReplicatorArn = ReplicatorArn)
  output <- .kafka$delete_replicator_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$delete_replicator <- kafka_delete_replicator

#' Deletes a MSK VPC connection
#'
#' @description
#' Deletes a MSK VPC connection.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_delete_vpc_connection/](https://www.paws-r-sdk.com/docs/kafka_delete_vpc_connection/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies an MSK VPC
#' connection.
#'
#' @keywords internal
#'
#' @rdname kafka_delete_vpc_connection
kafka_delete_vpc_connection <- function(Arn) {
  op <- new_operation(
    name = "DeleteVpcConnection",
    http_method = "DELETE",
    http_path = "/v1/vpc-connection/{arn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$delete_vpc_connection_input(Arn = Arn)
  output <- .kafka$delete_vpc_connection_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$delete_vpc_connection <- kafka_delete_vpc_connection

#' Returns a description of the MSK cluster whose Amazon Resource Name
#' (ARN) is specified in the request
#'
#' @description
#' Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_describe_cluster/](https://www.paws-r-sdk.com/docs/kafka_describe_cluster/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#'
#' @keywords internal
#'
#' @rdname kafka_describe_cluster
kafka_describe_cluster <- function(ClusterArn) {
  op <- new_operation(
    name = "DescribeCluster",
    http_method = "GET",
    http_path = "/v1/clusters/{clusterArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$describe_cluster_input(ClusterArn = ClusterArn)
  output <- .kafka$describe_cluster_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$describe_cluster <- kafka_describe_cluster

#' Returns a description of the MSK cluster whose Amazon Resource Name
#' (ARN) is specified in the request
#'
#' @description
#' Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_describe_cluster_v2/](https://www.paws-r-sdk.com/docs/kafka_describe_cluster_v2/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#'
#' @keywords internal
#'
#' @rdname kafka_describe_cluster_v2
kafka_describe_cluster_v2 <- function(ClusterArn) {
  op <- new_operation(
    name = "DescribeClusterV2",
    http_method = "GET",
    http_path = "/api/v2/clusters/{clusterArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$describe_cluster_v2_input(ClusterArn = ClusterArn)
  output <- .kafka$describe_cluster_v2_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$describe_cluster_v2 <- kafka_describe_cluster_v2

#' Returns a description of the cluster operation specified by the ARN
#'
#' @description
#' Returns a description of the cluster operation specified by the ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_describe_cluster_operation/](https://www.paws-r-sdk.com/docs/kafka_describe_cluster_operation/) for full documentation.
#'
#' @param ClusterOperationArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the MSK cluster
#' operation.
#'
#' @keywords internal
#'
#' @rdname kafka_describe_cluster_operation
kafka_describe_cluster_operation <- function(ClusterOperationArn) {
  op <- new_operation(
    name = "DescribeClusterOperation",
    http_method = "GET",
    http_path = "/v1/operations/{clusterOperationArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$describe_cluster_operation_input(ClusterOperationArn = ClusterOperationArn)
  output <- .kafka$describe_cluster_operation_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$describe_cluster_operation <- kafka_describe_cluster_operation

#' Returns a description of the cluster operation specified by the ARN
#'
#' @description
#' Returns a description of the cluster operation specified by the ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_describe_cluster_operation_v2/](https://www.paws-r-sdk.com/docs/kafka_describe_cluster_operation_v2/) for full documentation.
#'
#' @param ClusterOperationArn &#91;required&#93; ARN of the cluster operation to describe.
#'
#' @keywords internal
#'
#' @rdname kafka_describe_cluster_operation_v2
kafka_describe_cluster_operation_v2 <- function(ClusterOperationArn) {
  op <- new_operation(
    name = "DescribeClusterOperationV2",
    http_method = "GET",
    http_path = "/api/v2/operations/{clusterOperationArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$describe_cluster_operation_v2_input(ClusterOperationArn = ClusterOperationArn)
  output <- .kafka$describe_cluster_operation_v2_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$describe_cluster_operation_v2 <- kafka_describe_cluster_operation_v2

#' Returns a description of this MSK configuration
#'
#' @description
#' Returns a description of this MSK configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_describe_configuration/](https://www.paws-r-sdk.com/docs/kafka_describe_configuration/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies an MSK
#' configuration and all of its revisions.
#'
#' @keywords internal
#'
#' @rdname kafka_describe_configuration
kafka_describe_configuration <- function(Arn) {
  op <- new_operation(
    name = "DescribeConfiguration",
    http_method = "GET",
    http_path = "/v1/configurations/{arn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$describe_configuration_input(Arn = Arn)
  output <- .kafka$describe_configuration_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$describe_configuration <- kafka_describe_configuration

#' Returns a description of this revision of the configuration
#'
#' @description
#' Returns a description of this revision of the configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_describe_configuration_revision/](https://www.paws-r-sdk.com/docs/kafka_describe_configuration_revision/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies an MSK
#' configuration and all of its revisions.
#' @param Revision &#91;required&#93; A string that uniquely identifies a revision of an MSK configuration.
#'
#' @keywords internal
#'
#' @rdname kafka_describe_configuration_revision
kafka_describe_configuration_revision <- function(Arn, Revision) {
  op <- new_operation(
    name = "DescribeConfigurationRevision",
    http_method = "GET",
    http_path = "/v1/configurations/{arn}/revisions/{revision}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$describe_configuration_revision_input(Arn = Arn, Revision = Revision)
  output <- .kafka$describe_configuration_revision_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$describe_configuration_revision <- kafka_describe_configuration_revision

#' Describes a replicator
#'
#' @description
#' Describes a replicator.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_describe_replicator/](https://www.paws-r-sdk.com/docs/kafka_describe_replicator/) for full documentation.
#'
#' @param ReplicatorArn &#91;required&#93; The Amazon Resource Name (ARN) of the replicator to be described.
#'
#' @keywords internal
#'
#' @rdname kafka_describe_replicator
kafka_describe_replicator <- function(ReplicatorArn) {
  op <- new_operation(
    name = "DescribeReplicator",
    http_method = "GET",
    http_path = "/replication/v1/replicators/{replicatorArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$describe_replicator_input(ReplicatorArn = ReplicatorArn)
  output <- .kafka$describe_replicator_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$describe_replicator <- kafka_describe_replicator

#' Returns a description of this MSK VPC connection
#'
#' @description
#' Returns a description of this MSK VPC connection.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_describe_vpc_connection/](https://www.paws-r-sdk.com/docs/kafka_describe_vpc_connection/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies a MSK VPC
#' connection.
#'
#' @keywords internal
#'
#' @rdname kafka_describe_vpc_connection
kafka_describe_vpc_connection <- function(Arn) {
  op <- new_operation(
    name = "DescribeVpcConnection",
    http_method = "GET",
    http_path = "/v1/vpc-connection/{arn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$describe_vpc_connection_input(Arn = Arn)
  output <- .kafka$describe_vpc_connection_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$describe_vpc_connection <- kafka_describe_vpc_connection

#' Disassociates one or more Scram Secrets from an Amazon MSK cluster
#'
#' @description
#' Disassociates one or more Scram Secrets from an Amazon MSK cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_batch_disassociate_scram_secret/](https://www.paws-r-sdk.com/docs/kafka_batch_disassociate_scram_secret/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) of the cluster to be updated.
#' @param SecretArnList &#91;required&#93; List of AWS Secrets Manager secret ARNs.
#'
#' @keywords internal
#'
#' @rdname kafka_batch_disassociate_scram_secret
kafka_batch_disassociate_scram_secret <- function(ClusterArn, SecretArnList) {
  op <- new_operation(
    name = "BatchDisassociateScramSecret",
    http_method = "PATCH",
    http_path = "/v1/clusters/{clusterArn}/scram-secrets",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$batch_disassociate_scram_secret_input(ClusterArn = ClusterArn, SecretArnList = SecretArnList)
  output <- .kafka$batch_disassociate_scram_secret_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$batch_disassociate_scram_secret <- kafka_batch_disassociate_scram_secret

#' A list of brokers that a client application can use to bootstrap
#'
#' @description
#' A list of brokers that a client application can use to bootstrap. This list doesn't necessarily include all of the brokers in the cluster. The following Python 3.6 example shows how you can use the Amazon Resource Name (ARN) of a cluster to get its bootstrap brokers. If you don't know the ARN of your cluster, you can use the [`list_clusters`][kafka_list_clusters] operation to get the ARNs of all the clusters in this account and Region.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_get_bootstrap_brokers/](https://www.paws-r-sdk.com/docs/kafka_get_bootstrap_brokers/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#'
#' @keywords internal
#'
#' @rdname kafka_get_bootstrap_brokers
kafka_get_bootstrap_brokers <- function(ClusterArn) {
  op <- new_operation(
    name = "GetBootstrapBrokers",
    http_method = "GET",
    http_path = "/v1/clusters/{clusterArn}/bootstrap-brokers",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$get_bootstrap_brokers_input(ClusterArn = ClusterArn)
  output <- .kafka$get_bootstrap_brokers_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$get_bootstrap_brokers <- kafka_get_bootstrap_brokers

#' Gets the Apache Kafka versions to which you can update the MSK cluster
#'
#' @description
#' Gets the Apache Kafka versions to which you can update the MSK cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_get_compatible_kafka_versions/](https://www.paws-r-sdk.com/docs/kafka_get_compatible_kafka_versions/) for full documentation.
#'
#' @param ClusterArn The Amazon Resource Name (ARN) of the cluster check.
#'
#' @keywords internal
#'
#' @rdname kafka_get_compatible_kafka_versions
kafka_get_compatible_kafka_versions <- function(ClusterArn = NULL) {
  op <- new_operation(
    name = "GetCompatibleKafkaVersions",
    http_method = "GET",
    http_path = "/v1/compatible-kafka-versions",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$get_compatible_kafka_versions_input(ClusterArn = ClusterArn)
  output <- .kafka$get_compatible_kafka_versions_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$get_compatible_kafka_versions <- kafka_get_compatible_kafka_versions

#' Get the MSK cluster policy specified by the Amazon Resource Name (ARN)
#' in the request
#'
#' @description
#' Get the MSK cluster policy specified by the Amazon Resource Name (ARN) in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_get_cluster_policy/](https://www.paws-r-sdk.com/docs/kafka_get_cluster_policy/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) of the cluster.
#'
#' @keywords internal
#'
#' @rdname kafka_get_cluster_policy
kafka_get_cluster_policy <- function(ClusterArn) {
  op <- new_operation(
    name = "GetClusterPolicy",
    http_method = "GET",
    http_path = "/v1/clusters/{clusterArn}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$get_cluster_policy_input(ClusterArn = ClusterArn)
  output <- .kafka$get_cluster_policy_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$get_cluster_policy <- kafka_get_cluster_policy

#' Returns a list of all the operations that have been performed on the
#' specified MSK cluster
#'
#' @description
#' Returns a list of all the operations that have been performed on the specified MSK cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_list_cluster_operations/](https://www.paws-r-sdk.com/docs/kafka_list_cluster_operations/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#' @param MaxResults The maximum number of results to return in the response. If there are
#' more results, the response includes a NextToken parameter.
#' @param NextToken The paginated results marker. When the result of the operation is
#' truncated, the call returns NextToken in the response. To get the next
#' batch, provide this token in your next request.
#'
#' @keywords internal
#'
#' @rdname kafka_list_cluster_operations
kafka_list_cluster_operations <- function(ClusterArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListClusterOperations",
    http_method = "GET",
    http_path = "/v1/clusters/{clusterArn}/operations",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ClusterOperationInfoList"),
    stream_api = FALSE
  )
  input <- .kafka$list_cluster_operations_input(ClusterArn = ClusterArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_cluster_operations_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_cluster_operations <- kafka_list_cluster_operations

#' Returns a list of all the operations that have been performed on the
#' specified MSK cluster
#'
#' @description
#' Returns a list of all the operations that have been performed on the specified MSK cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_list_cluster_operations_v2/](https://www.paws-r-sdk.com/docs/kafka_list_cluster_operations_v2/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The arn of the cluster whose operations are being requested.
#' @param MaxResults The maxResults of the query.
#' @param NextToken The nextToken of the query.
#'
#' @keywords internal
#'
#' @rdname kafka_list_cluster_operations_v2
kafka_list_cluster_operations_v2 <- function(ClusterArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListClusterOperationsV2",
    http_method = "GET",
    http_path = "/api/v2/clusters/{clusterArn}/operations",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ClusterOperationInfoList"),
    stream_api = FALSE
  )
  input <- .kafka$list_cluster_operations_v2_input(ClusterArn = ClusterArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_cluster_operations_v2_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_cluster_operations_v2 <- kafka_list_cluster_operations_v2

#' Returns a list of all the MSK clusters in the current Region
#'
#' @description
#' Returns a list of all the MSK clusters in the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_list_clusters/](https://www.paws-r-sdk.com/docs/kafka_list_clusters/) for full documentation.
#'
#' @param ClusterNameFilter Specify a prefix of the name of the clusters that you want to list. The
#' service lists all the clusters whose names start with this prefix.
#' @param MaxResults The maximum number of results to return in the response. If there are
#' more results, the response includes a NextToken parameter.
#' @param NextToken The paginated results marker. When the result of the operation is
#' truncated, the call returns NextToken in the response. To get the next
#' batch, provide this token in your next request.
#'
#' @keywords internal
#'
#' @rdname kafka_list_clusters
kafka_list_clusters <- function(ClusterNameFilter = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListClusters",
    http_method = "GET",
    http_path = "/v1/clusters",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "ClusterInfoList"),
    stream_api = FALSE
  )
  input <- .kafka$list_clusters_input(ClusterNameFilter = ClusterNameFilter, MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_clusters_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_clusters <- kafka_list_clusters

#' Returns a list of all the MSK clusters in the current Region
#'
#' @description
#' Returns a list of all the MSK clusters in the current Region.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_list_clusters_v2/](https://www.paws-r-sdk.com/docs/kafka_list_clusters_v2/) for full documentation.
#'
#' @param ClusterNameFilter Specify a prefix of the names of the clusters that you want to list. The
#' service lists all the clusters whose names start with this prefix.
#' @param ClusterTypeFilter Specify either PROVISIONED or SERVERLESS.
#' @param MaxResults The maximum number of results to return in the response. If there are
#' more results, the response includes a NextToken parameter.
#' @param NextToken The paginated results marker. When the result of the operation is
#' truncated, the call returns NextToken in the response. To get the next
#' batch, provide this token in your next request.
#'
#' @keywords internal
#'
#' @rdname kafka_list_clusters_v2
kafka_list_clusters_v2 <- function(ClusterNameFilter = NULL, ClusterTypeFilter = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListClustersV2",
    http_method = "GET",
    http_path = "/api/v2/clusters",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ClusterInfoList"),
    stream_api = FALSE
  )
  input <- .kafka$list_clusters_v2_input(ClusterNameFilter = ClusterNameFilter, ClusterTypeFilter = ClusterTypeFilter, MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_clusters_v2_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_clusters_v2 <- kafka_list_clusters_v2

#' Returns a list of all the MSK configurations in this Region
#'
#' @description
#' Returns a list of all the MSK configurations in this Region.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_list_configuration_revisions/](https://www.paws-r-sdk.com/docs/kafka_list_configuration_revisions/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies an MSK
#' configuration and all of its revisions.
#' @param MaxResults The maximum number of results to return in the response. If there are
#' more results, the response includes a NextToken parameter.
#' @param NextToken The paginated results marker. When the result of the operation is
#' truncated, the call returns NextToken in the response. To get the next
#' batch, provide this token in your next request.
#'
#' @keywords internal
#'
#' @rdname kafka_list_configuration_revisions
kafka_list_configuration_revisions <- function(Arn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListConfigurationRevisions",
    http_method = "GET",
    http_path = "/v1/configurations/{arn}/revisions",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Revisions"),
    stream_api = FALSE
  )
  input <- .kafka$list_configuration_revisions_input(Arn = Arn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_configuration_revisions_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_configuration_revisions <- kafka_list_configuration_revisions

#' Returns a list of all the MSK configurations in this Region
#'
#' @description
#' Returns a list of all the MSK configurations in this Region.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_list_configurations/](https://www.paws-r-sdk.com/docs/kafka_list_configurations/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return in the response. If there are
#' more results, the response includes a NextToken parameter.
#' @param NextToken The paginated results marker. When the result of the operation is
#' truncated, the call returns NextToken in the response. To get the next
#' batch, provide this token in your next request.
#'
#' @keywords internal
#'
#' @rdname kafka_list_configurations
kafka_list_configurations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListConfigurations",
    http_method = "GET",
    http_path = "/v1/configurations",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Configurations"),
    stream_api = FALSE
  )
  input <- .kafka$list_configurations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_configurations_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_configurations <- kafka_list_configurations

#' Returns a list of Apache Kafka versions
#'
#' @description
#' Returns a list of Apache Kafka versions.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_list_kafka_versions/](https://www.paws-r-sdk.com/docs/kafka_list_kafka_versions/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return in the response. If there are
#' more results, the response includes a NextToken parameter.
#' @param NextToken The paginated results marker. When the result of the operation is
#' truncated, the call returns NextToken in the response. To get the next
#' batch, provide this token in your next request.
#'
#' @keywords internal
#'
#' @rdname kafka_list_kafka_versions
kafka_list_kafka_versions <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListKafkaVersions",
    http_method = "GET",
    http_path = "/v1/kafka-versions",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "KafkaVersions"),
    stream_api = FALSE
  )
  input <- .kafka$list_kafka_versions_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_kafka_versions_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_kafka_versions <- kafka_list_kafka_versions

#' Returns a list of the broker nodes in the cluster
#'
#' @description
#' Returns a list of the broker nodes in the cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_list_nodes/](https://www.paws-r-sdk.com/docs/kafka_list_nodes/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#' @param MaxResults The maximum number of results to return in the response. If there are
#' more results, the response includes a NextToken parameter.
#' @param NextToken The paginated results marker. When the result of the operation is
#' truncated, the call returns NextToken in the response. To get the next
#' batch, provide this token in your next request.
#'
#' @keywords internal
#'
#' @rdname kafka_list_nodes
kafka_list_nodes <- function(ClusterArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListNodes",
    http_method = "GET",
    http_path = "/v1/clusters/{clusterArn}/nodes",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "NodeInfoList"),
    stream_api = FALSE
  )
  input <- .kafka$list_nodes_input(ClusterArn = ClusterArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_nodes_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_nodes <- kafka_list_nodes

#' Lists the replicators
#'
#' @description
#' Lists the replicators.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_list_replicators/](https://www.paws-r-sdk.com/docs/kafka_list_replicators/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return in the response. If there are
#' more results, the response includes a NextToken parameter.
#' @param NextToken If the response of ListReplicators is truncated, it returns a NextToken
#' in the response. This NextToken should be sent in the subsequent request
#' to ListReplicators.
#' @param ReplicatorNameFilter Returns replicators starting with given name.
#'
#' @keywords internal
#'
#' @rdname kafka_list_replicators
kafka_list_replicators <- function(MaxResults = NULL, NextToken = NULL, ReplicatorNameFilter = NULL) {
  op <- new_operation(
    name = "ListReplicators",
    http_method = "GET",
    http_path = "/replication/v1/replicators",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Replicators"),
    stream_api = FALSE
  )
  input <- .kafka$list_replicators_input(MaxResults = MaxResults, NextToken = NextToken, ReplicatorNameFilter = ReplicatorNameFilter)
  output <- .kafka$list_replicators_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_replicators <- kafka_list_replicators

#' Returns a list of the Scram Secrets associated with an Amazon MSK
#' cluster
#'
#' @description
#' Returns a list of the Scram Secrets associated with an Amazon MSK cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_list_scram_secrets/](https://www.paws-r-sdk.com/docs/kafka_list_scram_secrets/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The arn of the cluster.
#' @param MaxResults The maxResults of the query.
#' @param NextToken The nextToken of the query.
#'
#' @keywords internal
#'
#' @rdname kafka_list_scram_secrets
kafka_list_scram_secrets <- function(ClusterArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListScramSecrets",
    http_method = "GET",
    http_path = "/v1/clusters/{clusterArn}/scram-secrets",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "SecretArnList"),
    stream_api = FALSE
  )
  input <- .kafka$list_scram_secrets_input(ClusterArn = ClusterArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_scram_secrets_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_scram_secrets <- kafka_list_scram_secrets

#' Returns a list of the tags associated with the specified resource
#'
#' @description
#' Returns a list of the tags associated with the specified resource.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/kafka_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the resource
#' that's associated with the tags.
#'
#' @keywords internal
#'
#' @rdname kafka_list_tags_for_resource
kafka_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/v1/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .kafka$list_tags_for_resource_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_tags_for_resource <- kafka_list_tags_for_resource

#' Returns a list of all the VPC connections in this Region
#'
#' @description
#' Returns a list of all the VPC connections in this Region.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_list_client_vpc_connections/](https://www.paws-r-sdk.com/docs/kafka_list_client_vpc_connections/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) of the cluster.
#' @param MaxResults The maximum number of results to return in the response. If there are
#' more results, the response includes a NextToken parameter.
#' @param NextToken The paginated results marker. When the result of the operation is
#' truncated, the call returns NextToken in the response. To get the next
#' batch, provide this token in your next request.
#'
#' @keywords internal
#'
#' @rdname kafka_list_client_vpc_connections
kafka_list_client_vpc_connections <- function(ClusterArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListClientVpcConnections",
    http_method = "GET",
    http_path = "/v1/clusters/{clusterArn}/client-vpc-connections",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ClientVpcConnections"),
    stream_api = FALSE
  )
  input <- .kafka$list_client_vpc_connections_input(ClusterArn = ClusterArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_client_vpc_connections_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_client_vpc_connections <- kafka_list_client_vpc_connections

#' Returns a list of all the VPC connections in this Region
#'
#' @description
#' Returns a list of all the VPC connections in this Region.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_list_vpc_connections/](https://www.paws-r-sdk.com/docs/kafka_list_vpc_connections/) for full documentation.
#'
#' @param MaxResults The maximum number of results to return in the response. If there are
#' more results, the response includes a NextToken parameter.
#' @param NextToken The paginated results marker. When the result of the operation is
#' truncated, the call returns NextToken in the response. To get the next
#' batch, provide this token in your next request.
#'
#' @keywords internal
#'
#' @rdname kafka_list_vpc_connections
kafka_list_vpc_connections <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListVpcConnections",
    http_method = "GET",
    http_path = "/v1/vpc-connections",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "VpcConnections"),
    stream_api = FALSE
  )
  input <- .kafka$list_vpc_connections_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .kafka$list_vpc_connections_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$list_vpc_connections <- kafka_list_vpc_connections

#' Returns empty response
#'
#' @description
#' Returns empty response.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_reject_client_vpc_connection/](https://www.paws-r-sdk.com/docs/kafka_reject_client_vpc_connection/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) of the cluster.
#' @param VpcConnectionArn &#91;required&#93; The VPC connection ARN.
#'
#' @keywords internal
#'
#' @rdname kafka_reject_client_vpc_connection
kafka_reject_client_vpc_connection <- function(ClusterArn, VpcConnectionArn) {
  op <- new_operation(
    name = "RejectClientVpcConnection",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/client-vpc-connection",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$reject_client_vpc_connection_input(ClusterArn = ClusterArn, VpcConnectionArn = VpcConnectionArn)
  output <- .kafka$reject_client_vpc_connection_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$reject_client_vpc_connection <- kafka_reject_client_vpc_connection

#' Creates or updates the MSK cluster policy specified by the cluster
#' Amazon Resource Name (ARN) in the request
#'
#' @description
#' Creates or updates the MSK cluster policy specified by the cluster Amazon Resource Name (ARN) in the request.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_put_cluster_policy/](https://www.paws-r-sdk.com/docs/kafka_put_cluster_policy/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) of the cluster.
#' @param CurrentVersion The policy version.
#' @param Policy &#91;required&#93; The policy.
#'
#' @keywords internal
#'
#' @rdname kafka_put_cluster_policy
kafka_put_cluster_policy <- function(ClusterArn, CurrentVersion = NULL, Policy) {
  op <- new_operation(
    name = "PutClusterPolicy",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/policy",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$put_cluster_policy_input(ClusterArn = ClusterArn, CurrentVersion = CurrentVersion, Policy = Policy)
  output <- .kafka$put_cluster_policy_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$put_cluster_policy <- kafka_put_cluster_policy

#' Reboots brokers
#'
#' @description
#' Reboots brokers.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_reboot_broker/](https://www.paws-r-sdk.com/docs/kafka_reboot_broker/) for full documentation.
#'
#' @param BrokerIds &#91;required&#93; The list of broker IDs to be rebooted. The reboot-broker operation
#' supports rebooting one broker at a time.
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) of the cluster to be updated.
#'
#' @keywords internal
#'
#' @rdname kafka_reboot_broker
kafka_reboot_broker <- function(BrokerIds, ClusterArn) {
  op <- new_operation(
    name = "RebootBroker",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/reboot-broker",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$reboot_broker_input(BrokerIds = BrokerIds, ClusterArn = ClusterArn)
  output <- .kafka$reboot_broker_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$reboot_broker <- kafka_reboot_broker

#' Adds tags to the specified MSK resource
#'
#' @description
#' Adds tags to the specified MSK resource.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_tag_resource/](https://www.paws-r-sdk.com/docs/kafka_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the resource
#' that's associated with the tags.
#' @param Tags &#91;required&#93; The key-value pair for the resource tag.
#'
#' @keywords internal
#'
#' @rdname kafka_tag_resource
kafka_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/v1/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .kafka$tag_resource_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$tag_resource <- kafka_tag_resource

#' Removes the tags associated with the keys that are provided in the query
#'
#' @description
#' Removes the tags associated with the keys that are provided in the query.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_untag_resource/](https://www.paws-r-sdk.com/docs/kafka_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the resource
#' that's associated with the tags.
#' @param TagKeys &#91;required&#93; Tag keys must be unique for a given cluster. In addition, the following
#' restrictions apply:
#' 
#' -   Each tag key must be unique. If you add a tag with a key that's
#'     already in use, your new tag overwrites the existing key-value pair.
#' 
#' -   You can't start a tag key with aws: because this prefix is reserved
#'     for use by AWS. AWS creates tags that begin with this prefix on your
#'     behalf, but you can't edit or delete them.
#' 
#' -   Tag keys must be between 1 and 128 Unicode characters in length.
#' 
#' -   Tag keys must consist of the following characters: Unicode letters,
#'     digits, white space, and the following special characters: _ . /
#'     = + - @@.
#'
#' @keywords internal
#'
#' @rdname kafka_untag_resource
kafka_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/v1/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .kafka$untag_resource_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$untag_resource <- kafka_untag_resource

#' Updates the number of broker nodes in the cluster
#'
#' @description
#' Updates the number of broker nodes in the cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_update_broker_count/](https://www.paws-r-sdk.com/docs/kafka_update_broker_count/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#' @param CurrentVersion &#91;required&#93; The version of cluster to update from. A successful operation will then
#' generate a new version.
#' @param TargetNumberOfBrokerNodes &#91;required&#93; The number of broker nodes that you want the cluster to have after this
#' operation completes successfully.
#'
#' @keywords internal
#'
#' @rdname kafka_update_broker_count
kafka_update_broker_count <- function(ClusterArn, CurrentVersion, TargetNumberOfBrokerNodes) {
  op <- new_operation(
    name = "UpdateBrokerCount",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/nodes/count",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$update_broker_count_input(ClusterArn = ClusterArn, CurrentVersion = CurrentVersion, TargetNumberOfBrokerNodes = TargetNumberOfBrokerNodes)
  output <- .kafka$update_broker_count_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_broker_count <- kafka_update_broker_count

#' Updates EC2 instance type
#'
#' @description
#' Updates EC2 instance type.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_update_broker_type/](https://www.paws-r-sdk.com/docs/kafka_update_broker_type/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#' @param CurrentVersion &#91;required&#93; The cluster version that you want to change. After this operation
#' completes successfully, the cluster will have a new version.
#' @param TargetInstanceType &#91;required&#93; The Amazon MSK broker type that you want all of the brokers in this
#' cluster to be.
#'
#' @keywords internal
#'
#' @rdname kafka_update_broker_type
kafka_update_broker_type <- function(ClusterArn, CurrentVersion, TargetInstanceType) {
  op <- new_operation(
    name = "UpdateBrokerType",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/nodes/type",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$update_broker_type_input(ClusterArn = ClusterArn, CurrentVersion = CurrentVersion, TargetInstanceType = TargetInstanceType)
  output <- .kafka$update_broker_type_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_broker_type <- kafka_update_broker_type

#' Updates the EBS storage associated with MSK brokers
#'
#' @description
#' Updates the EBS storage associated with MSK brokers.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_update_broker_storage/](https://www.paws-r-sdk.com/docs/kafka_update_broker_storage/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#' @param CurrentVersion &#91;required&#93; The version of cluster to update from. A successful operation will then
#' generate a new version.
#' @param TargetBrokerEBSVolumeInfo &#91;required&#93; Describes the target volume size and the ID of the broker to apply the
#' update to.
#'
#' @keywords internal
#'
#' @rdname kafka_update_broker_storage
kafka_update_broker_storage <- function(ClusterArn, CurrentVersion, TargetBrokerEBSVolumeInfo) {
  op <- new_operation(
    name = "UpdateBrokerStorage",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/nodes/storage",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$update_broker_storage_input(ClusterArn = ClusterArn, CurrentVersion = CurrentVersion, TargetBrokerEBSVolumeInfo = TargetBrokerEBSVolumeInfo)
  output <- .kafka$update_broker_storage_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_broker_storage <- kafka_update_broker_storage

#' Updates an MSK configuration
#'
#' @description
#' Updates an MSK configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_update_configuration/](https://www.paws-r-sdk.com/docs/kafka_update_configuration/) for full documentation.
#'
#' @param Arn &#91;required&#93; The Amazon Resource Name (ARN) of the configuration.
#' @param Description The description of the configuration revision.
#' @param ServerProperties &#91;required&#93; Contents of the server.properties file. When using the API, you must
#' ensure that the contents of the file are base64 encoded. When using the
#' AWS Management Console, the SDK, or the AWS CLI, the contents of
#' server.properties can be in plaintext.
#'
#' @keywords internal
#'
#' @rdname kafka_update_configuration
kafka_update_configuration <- function(Arn, Description = NULL, ServerProperties) {
  op <- new_operation(
    name = "UpdateConfiguration",
    http_method = "PUT",
    http_path = "/v1/configurations/{arn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$update_configuration_input(Arn = Arn, Description = Description, ServerProperties = ServerProperties)
  output <- .kafka$update_configuration_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_configuration <- kafka_update_configuration

#' Updates the cluster's connectivity configuration
#'
#' @description
#' Updates the cluster's connectivity configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_update_connectivity/](https://www.paws-r-sdk.com/docs/kafka_update_connectivity/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) of the configuration.
#' @param ConnectivityInfo &#91;required&#93; Information about the broker access configuration.
#' @param CurrentVersion &#91;required&#93; The version of the MSK cluster to update. Cluster versions aren't simple
#' numbers. You can describe an MSK cluster to find its version. When this
#' update operation is successful, it generates a new cluster version.
#'
#' @keywords internal
#'
#' @rdname kafka_update_connectivity
kafka_update_connectivity <- function(ClusterArn, ConnectivityInfo, CurrentVersion) {
  op <- new_operation(
    name = "UpdateConnectivity",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/connectivity",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$update_connectivity_input(ClusterArn = ClusterArn, ConnectivityInfo = ConnectivityInfo, CurrentVersion = CurrentVersion)
  output <- .kafka$update_connectivity_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_connectivity <- kafka_update_connectivity

#' Updates the cluster with the configuration that is specified in the
#' request body
#'
#' @description
#' Updates the cluster with the configuration that is specified in the request body.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_update_cluster_configuration/](https://www.paws-r-sdk.com/docs/kafka_update_cluster_configuration/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#' @param ConfigurationInfo &#91;required&#93; Represents the configuration that you want MSK to use for the brokers in
#' a cluster.
#' @param CurrentVersion &#91;required&#93; The version of the cluster that needs to be updated.
#'
#' @keywords internal
#'
#' @rdname kafka_update_cluster_configuration
kafka_update_cluster_configuration <- function(ClusterArn, ConfigurationInfo, CurrentVersion) {
  op <- new_operation(
    name = "UpdateClusterConfiguration",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$update_cluster_configuration_input(ClusterArn = ClusterArn, ConfigurationInfo = ConfigurationInfo, CurrentVersion = CurrentVersion)
  output <- .kafka$update_cluster_configuration_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_cluster_configuration <- kafka_update_cluster_configuration

#' Updates the Apache Kafka version for the cluster
#'
#' @description
#' Updates the Apache Kafka version for the cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_update_cluster_kafka_version/](https://www.paws-r-sdk.com/docs/kafka_update_cluster_kafka_version/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) of the cluster to be updated.
#' @param ConfigurationInfo The custom configuration that should be applied on the new version of
#' cluster.
#' @param CurrentVersion &#91;required&#93; Current cluster version.
#' @param TargetKafkaVersion &#91;required&#93; Target Kafka version.
#'
#' @keywords internal
#'
#' @rdname kafka_update_cluster_kafka_version
kafka_update_cluster_kafka_version <- function(ClusterArn, ConfigurationInfo = NULL, CurrentVersion, TargetKafkaVersion) {
  op <- new_operation(
    name = "UpdateClusterKafkaVersion",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/version",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$update_cluster_kafka_version_input(ClusterArn = ClusterArn, ConfigurationInfo = ConfigurationInfo, CurrentVersion = CurrentVersion, TargetKafkaVersion = TargetKafkaVersion)
  output <- .kafka$update_cluster_kafka_version_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_cluster_kafka_version <- kafka_update_cluster_kafka_version

#' Updates the monitoring settings for the cluster
#'
#' @description
#' Updates the monitoring settings for the cluster. You can use this operation to specify which Apache Kafka metrics you want Amazon MSK to send to Amazon CloudWatch. You can also specify settings for open monitoring with Prometheus.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_update_monitoring/](https://www.paws-r-sdk.com/docs/kafka_update_monitoring/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#' @param CurrentVersion &#91;required&#93; The version of the MSK cluster to update. Cluster versions aren't simple
#' numbers. You can describe an MSK cluster to find its version. When this
#' update operation is successful, it generates a new cluster version.
#' @param EnhancedMonitoring Specifies which Apache Kafka metrics Amazon MSK gathers and sends to
#' Amazon CloudWatch for this cluster.
#' @param OpenMonitoring The settings for open monitoring.
#' @param LoggingInfo 
#'
#' @keywords internal
#'
#' @rdname kafka_update_monitoring
kafka_update_monitoring <- function(ClusterArn, CurrentVersion, EnhancedMonitoring = NULL, OpenMonitoring = NULL, LoggingInfo = NULL) {
  op <- new_operation(
    name = "UpdateMonitoring",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/monitoring",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$update_monitoring_input(ClusterArn = ClusterArn, CurrentVersion = CurrentVersion, EnhancedMonitoring = EnhancedMonitoring, OpenMonitoring = OpenMonitoring, LoggingInfo = LoggingInfo)
  output <- .kafka$update_monitoring_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_monitoring <- kafka_update_monitoring

#' Updates replication info of a replicator
#'
#' @description
#' Updates replication info of a replicator.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_update_replication_info/](https://www.paws-r-sdk.com/docs/kafka_update_replication_info/) for full documentation.
#'
#' @param ConsumerGroupReplication Updated consumer group replication information.
#' @param CurrentVersion &#91;required&#93; Current replicator version.
#' @param ReplicatorArn &#91;required&#93; The Amazon Resource Name (ARN) of the replicator to be updated.
#' @param SourceKafkaClusterArn &#91;required&#93; The ARN of the source Kafka cluster.
#' @param TargetKafkaClusterArn &#91;required&#93; The ARN of the target Kafka cluster.
#' @param TopicReplication Updated topic replication information.
#'
#' @keywords internal
#'
#' @rdname kafka_update_replication_info
kafka_update_replication_info <- function(ConsumerGroupReplication = NULL, CurrentVersion, ReplicatorArn, SourceKafkaClusterArn, TargetKafkaClusterArn, TopicReplication = NULL) {
  op <- new_operation(
    name = "UpdateReplicationInfo",
    http_method = "PUT",
    http_path = "/replication/v1/replicators/{replicatorArn}/replication-info",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$update_replication_info_input(ConsumerGroupReplication = ConsumerGroupReplication, CurrentVersion = CurrentVersion, ReplicatorArn = ReplicatorArn, SourceKafkaClusterArn = SourceKafkaClusterArn, TargetKafkaClusterArn = TargetKafkaClusterArn, TopicReplication = TopicReplication)
  output <- .kafka$update_replication_info_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_replication_info <- kafka_update_replication_info

#' Updates the security settings for the cluster
#'
#' @description
#' Updates the security settings for the cluster. You can use this operation to specify encryption and authentication on existing clusters.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_update_security/](https://www.paws-r-sdk.com/docs/kafka_update_security/) for full documentation.
#'
#' @param ClientAuthentication Includes all client authentication related information.
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) that uniquely identifies the cluster.
#' @param CurrentVersion &#91;required&#93; The version of the MSK cluster to update. Cluster versions aren't simple
#' numbers. You can describe an MSK cluster to find its version. When this
#' update operation is successful, it generates a new cluster version.
#' @param EncryptionInfo Includes all encryption-related information.
#'
#' @keywords internal
#'
#' @rdname kafka_update_security
kafka_update_security <- function(ClientAuthentication = NULL, ClusterArn, CurrentVersion, EncryptionInfo = NULL) {
  op <- new_operation(
    name = "UpdateSecurity",
    http_method = "PATCH",
    http_path = "/v1/clusters/{clusterArn}/security",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$update_security_input(ClientAuthentication = ClientAuthentication, ClusterArn = ClusterArn, CurrentVersion = CurrentVersion, EncryptionInfo = EncryptionInfo)
  output <- .kafka$update_security_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_security <- kafka_update_security

#' Updates cluster broker volume size (or) sets cluster storage mode to
#' TIERED
#'
#' @description
#' Updates cluster broker volume size (or) sets cluster storage mode to TIERED.
#'
#' See [https://www.paws-r-sdk.com/docs/kafka_update_storage/](https://www.paws-r-sdk.com/docs/kafka_update_storage/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) of the cluster to be updated.
#' @param CurrentVersion &#91;required&#93; The version of cluster to update from. A successful operation will then
#' generate a new version.
#' @param ProvisionedThroughput EBS volume provisioned throughput information.
#' @param StorageMode Controls storage mode for supported storage tiers.
#' @param VolumeSizeGB size of the EBS volume to update.
#'
#' @keywords internal
#'
#' @rdname kafka_update_storage
kafka_update_storage <- function(ClusterArn, CurrentVersion, ProvisionedThroughput = NULL, StorageMode = NULL, VolumeSizeGB = NULL) {
  op <- new_operation(
    name = "UpdateStorage",
    http_method = "PUT",
    http_path = "/v1/clusters/{clusterArn}/storage",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .kafka$update_storage_input(ClusterArn = ClusterArn, CurrentVersion = CurrentVersion, ProvisionedThroughput = ProvisionedThroughput, StorageMode = StorageMode, VolumeSizeGB = VolumeSizeGB)
  output <- .kafka$update_storage_output()
  config <- get_config()
  svc <- .kafka$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafka$operations$update_storage <- kafka_update_storage
