% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_create_vpc_connection}
\alias{quicksight_create_vpc_connection}
\title{Creates a new VPC connection}
\usage{
quicksight_create_vpc_connection(
  AwsAccountId,
  VPCConnectionId,
  Name,
  SubnetIds,
  SecurityGroupIds,
  DnsResolvers = NULL,
  RoleArn,
  Tags = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The Amazon Web Services account ID of the account where you want to
create a new VPC connection.}

\item{VPCConnectionId}{[required] The ID of the VPC connection that you're creating. This ID is a unique
identifier for each Amazon Web Services Region in an Amazon Web Services
account.}

\item{Name}{[required] The display name for the VPC connection.}

\item{SubnetIds}{[required] A list of subnet IDs for the VPC connection.}

\item{SecurityGroupIds}{[required] A list of security group IDs for the VPC connection.}

\item{DnsResolvers}{A list of IP addresses of DNS resolver endpoints for the VPC connection.}

\item{RoleArn}{[required] The IAM role to associate with the VPC connection.}

\item{Tags}{A map of the key-value pairs for the resource tag or tags assigned to
the VPC connection.}
}
\description{
Creates a new VPC connection.

See \url{https://www.paws-r-sdk.com/docs/quicksight_create_vpc_connection/} for full documentation.
}
\keyword{internal}
