% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_list_map_runs}
\alias{sfn_list_map_runs}
\title{Lists all Map Runs that were started by a given state machine execution}
\usage{
sfn_list_map_runs(executionArn, maxResults = NULL, nextToken = NULL)
}
\arguments{
\item{executionArn}{[required] The Amazon Resource Name (ARN) of the execution for which the Map Runs
must be listed.}

\item{maxResults}{The maximum number of results that are returned per call. You can use
\code{nextToken} to obtain further pages of results. The default is 100 and
the maximum allowed page size is 1000. A value of 0 uses the default.

This is only an upper limit. The actual number of results returned per
call might be fewer than the specified maximum.}

\item{nextToken}{If \code{nextToken} is returned, there are more results available. The value
of \code{nextToken} is a unique pagination token for each page. Make the call
again using the returned token to retrieve the next page. Keep all other
arguments unchanged. Each pagination token expires after 24 hours. Using
an expired pagination token will return an \emph{HTTP 400 InvalidToken}
error.}
}
\description{
Lists all Map Runs that were started by a given state machine execution. Use this API action to obtain Map Run ARNs, and then call \code{\link[=sfn_describe_map_run]{describe_map_run}} to obtain more information, if needed.

See \url{https://www.paws-r-sdk.com/docs/sfn_list_map_runs/} for full documentation.
}
\keyword{internal}
