% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_bucket}
\alias{lightsail_create_bucket}
\title{Creates an Amazon Lightsail bucket}
\usage{
lightsail_create_bucket(
  bucketName,
  bundleId,
  tags = NULL,
  enableObjectVersioning = NULL
)
}
\arguments{
\item{bucketName}{[required] The name for the bucket.

For more information about bucket names, see \href{https://docs.aws.amazon.com/lightsail/latest/userguide/bucket-naming-rules-in-amazon-lightsail.html}{Bucket naming rules in Amazon Lightsail}
in the \emph{Amazon Lightsail Developer Guide}.}

\item{bundleId}{[required] The ID of the bundle to use for the bucket.

A bucket bundle specifies the monthly cost, storage space, and data
transfer quota for a bucket.

Use the \code{\link[=lightsail_get_bucket_bundles]{get_bucket_bundles}} action to
get a list of bundle IDs that you can specify.

Use the \code{\link[=lightsail_update_bucket_bundle]{update_bucket_bundle}} action
to change the bundle after the bucket is created.}

\item{tags}{The tag keys and optional values to add to the bucket during creation.

Use the \code{\link[=lightsail_tag_resource]{tag_resource}} action to tag the
bucket after it's created.}

\item{enableObjectVersioning}{A Boolean value that indicates whether to enable versioning of objects
in the bucket.

For more information about versioning, see \href{https://docs.aws.amazon.com/lightsail/latest/userguide/amazon-lightsail-managing-bucket-object-versioning.html}{Enabling and suspending object versioning in a bucket in Amazon Lightsail}
in the \emph{Amazon Lightsail Developer Guide}.}
}
\description{
Creates an Amazon Lightsail bucket.

See \url{https://www.paws-r-sdk.com/docs/lightsail_create_bucket/} for full documentation.
}
\keyword{internal}
