% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_search_training_plan_offerings}
\alias{sagemaker_search_training_plan_offerings}
\title{Searches for available training plan offerings based on specified
criteria}
\usage{
sagemaker_search_training_plan_offerings(
  InstanceType,
  InstanceCount,
  StartTimeAfter = NULL,
  EndTimeBefore = NULL,
  DurationHours = NULL,
  TargetResources
)
}
\arguments{
\item{InstanceType}{[required] The type of instance you want to search for in the available training
plan offerings. This field allows you to filter the search results based
on the specific compute resources you require for your SageMaker
training jobs or SageMaker HyperPod clusters. When searching for
training plan offerings, specifying the instance type helps you find
Reserved Instances that match your computational needs.}

\item{InstanceCount}{[required] The number of instances you want to reserve in the training plan
offerings. This allows you to specify the quantity of compute resources
needed for your SageMaker training jobs or SageMaker HyperPod clusters,
helping you find reserved capacity offerings that match your
requirements.}

\item{StartTimeAfter}{A filter to search for training plan offerings with a start time after a
specified date.}

\item{EndTimeBefore}{A filter to search for reserved capacity offerings with an end time
before a specified date.}

\item{DurationHours}{The desired duration in hours for the training plan offerings.}

\item{TargetResources}{[required] The target resources (e.g., SageMaker Training Jobs, SageMaker HyperPod)
to search for in the offerings.

Training plans are specific to their target resource.
\itemize{
\item A training plan designed for SageMaker training jobs can only be
used to schedule and run training jobs.
\item A training plan for HyperPod clusters can be used exclusively to
provide compute resources to a cluster's instance group.
}}
}
\description{
Searches for available training plan offerings based on specified criteria.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_search_training_plan_offerings/} for full documentation.
}
\keyword{internal}
