% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_list_resource_scan_resources}
\alias{cloudformation_list_resource_scan_resources}
\title{Lists the resources from a resource scan}
\usage{
cloudformation_list_resource_scan_resources(
  ResourceScanId,
  ResourceIdentifier = NULL,
  ResourceTypePrefix = NULL,
  TagKey = NULL,
  TagValue = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{ResourceScanId}{[required] The Amazon Resource Name (ARN) of the resource scan.}

\item{ResourceIdentifier}{If specified, the returned resources will have the specified resource
identifier (or one of them in the case where the resource has multiple
identifiers).}

\item{ResourceTypePrefix}{If specified, the returned resources will be of any of the resource
types with the specified prefix.}

\item{TagKey}{If specified, the returned resources will have a matching tag key.}

\item{TagValue}{If specified, the returned resources will have a matching tag value.}

\item{NextToken}{A string that identifies the next page of resource scan results.}

\item{MaxResults}{If the number of available results exceeds this maximum, the response
includes a \code{NextToken} value that you can use for the \code{NextToken}
parameter to get the next set of results. By default the
\code{\link[=cloudformation_list_resource_scan_resources]{list_resource_scan_resources}}
API action will return at most 100 results in each response. The maximum
value is 100.}
}
\description{
Lists the resources from a resource scan. The results can be filtered by resource identifier, resource type prefix, tag key, and tag value. Only resources that match all specified filters are returned. The response indicates whether each returned resource is already managed by CloudFormation.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_list_resource_scan_resources/} for full documentation.
}
\keyword{internal}
