% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/organizations_operations.R
\name{organizations_list_policies_for_target}
\alias{organizations_list_policies_for_target}
\title{Lists the policies that are directly attached to the specified target
root, organizational unit (OU), or account}
\usage{
organizations_list_policies_for_target(
  TargetId,
  Filter,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{TargetId}{[required] The unique identifier (ID) of the root, organizational unit, or account
whose policies you want to list.

The \href{https://en.wikipedia.org/wiki/Regex}{regex pattern} for a target ID
string requires one of the following:
\itemize{
\item \strong{Root} - A string that begins with "r-" followed by from 4 to 32
lowercase letters or digits.
\item \strong{Account} - A string that consists of exactly 12 digits.
\item \strong{Organizational unit (OU)} - A string that begins with "ou-"
followed by from 4 to 32 lowercase letters or digits (the ID of the
root that the OU is in). This string is followed by a second "-"
dash and from 8 to 32 additional lowercase letters or digits.
}}

\item{Filter}{[required] The type of policy that you want to include in the returned list. You
must specify one of the following values:
\itemize{
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html}{SERVICE_CONTROL_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_rcps.html}{RESOURCE_CONTROL_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_declarative.html}{DECLARATIVE_POLICY_EC2}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_backup.html}{BACKUP_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_tag-policies.html}{TAG_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_chatbot.html}{CHATBOT_POLICY}
\item \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html}{AISERVICES_OPT_OUT_POLICY}
}}

\item{NextToken}{The parameter for receiving additional results if you receive a
\code{NextToken} response in a previous request. A \code{NextToken} response
indicates that more output is available. Set this parameter to the value
of the previous call's \code{NextToken} response to indicate where the output
should continue from.}

\item{MaxResults}{The total number of results that you want included on each page of the
response. If you do not include this parameter, it defaults to a value
that is specific to the operation. If additional items exist beyond the
maximum you specify, the \code{NextToken} response element is present and has
a value (is not null). Include that value as the \code{NextToken} request
parameter in the next call to the operation to get the next part of the
results. Note that Organizations might return fewer results than the
maximum even when there are more results available. You should check
\code{NextToken} after every operation to ensure that you receive all of the
results.}
}
\description{
Lists the policies that are directly attached to the specified target root, organizational unit (OU), or account. You must specify the policy type that you want included in the returned list.

See \url{https://www.paws-r-sdk.com/docs/organizations_list_policies_for_target/} for full documentation.
}
\keyword{internal}
