% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_describe_create_case_options}
\alias{support_describe_create_case_options}
\title{Returns a list of CreateCaseOption types along with the corresponding
supported hours and language availability}
\usage{
support_describe_create_case_options(
  issueType,
  serviceCode,
  language,
  categoryCode
)
}
\arguments{
\item{issueType}{[required] The type of issue for the case. You can specify \code{customer-service} or
\code{technical}. If you don't specify a value, the default is \code{technical}.}

\item{serviceCode}{[required] The code for the Amazon Web Services service. You can use the
\code{\link[=support_describe_services]{describe_services}} operation to get the
possible \code{serviceCode} values.}

\item{language}{[required] The language in which Amazon Web Services Support handles the case.
Amazon Web Services Support currently supports Chinese (“zh”), English
("en"), Japanese ("ja") and Korean (“ko”). You must specify the ISO
639-1 code for the \code{language} parameter if you want support in that
language.}

\item{categoryCode}{[required] The category of problem for the support case. You also use the
\code{\link[=support_describe_services]{describe_services}} operation to get the
category code for a service. Each Amazon Web Services service defines
its own set of category codes.}
}
\description{
Returns a list of CreateCaseOption types along with the corresponding supported hours and language availability. You can specify the \code{language} \code{categoryCode}, \code{issueType} and \code{serviceCode} used to retrieve the CreateCaseOptions.

See \url{https://www.paws-r-sdk.com/docs/support_describe_create_case_options/} for full documentation.
}
\keyword{internal}
