% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_update_server_certificate}
\alias{iam_update_server_certificate}
\title{Updates the name and/or the path of the specified server certificate
stored in IAM}
\usage{
iam_update_server_certificate(
  ServerCertificateName,
  NewPath = NULL,
  NewServerCertificateName = NULL
)
}
\arguments{
\item{ServerCertificateName}{[required] The name of the server certificate that you want to update.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{NewPath}{The new path for the server certificate. Include this only if you are
updating the server certificate's path.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\code{U+0021}) through the DEL character
(\verb{U+007F}), including most punctuation characters, digits, and upper and
lowercased letters.}

\item{NewServerCertificateName}{The new name for the server certificate. Include this only if you are
updating the server certificate's name. The name of the certificate
cannot contain any spaces.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}
}
\description{
Updates the name and/or the path of the specified server certificate stored in IAM.

See \url{https://www.paws-r-sdk.com/docs/iam_update_server_certificate/} for full documentation.
}
\keyword{internal}
