% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COLA.R
\name{cola_glmm}
\alias{cola_glmm}
\title{COLA-GLMM}
\usage{
cola_glmm(
  summary_by_site,
  family = "poisson",
  intercept = TRUE,
  beta_init = NULL,
  u_init = NULL,
  max_iter = 50,
  tol = 1e-06,
  verbose = TRUE
)
}
\arguments{
\item{summary_by_site}{Named list of site summaries. Each element must contain
\code{Ck}, \code{Sk}, \code{S2k}, and \code{X0} as returned by
\code{generate_CSU_site}. The list names should be site IDs.}

\item{family}{Character; one of \code{"poisson"} or \code{"binomial"}
(canonical links).}

\item{intercept}{Logical; whether the fixed-effect design includes an
intercept (affects how \code{X0} was constructed). Default \code{TRUE}.}

\item{beta_init}{Optional named numeric vector of initial fixed effects.
Defaults to zeros.}

\item{u_init}{Optional named numeric vector of initial site random effects
(one per site). Defaults to zeros.}

\item{max_iter}{Integer maximum number of IRLS iterations. Default \code{50}.}

\item{tol}{Convergence tolerance on relative squared parameter change.
Default \code{1e-6}.}

\item{verbose}{Logical; print iteration progress. Default \code{TRUE}.}
}
\value{
A list with elements:
  \itemize{
    \item \code{beta}: named fixed-effect estimates
    \item \code{u}: named site random-intercept BLUPs
    \item \code{V}: variance component matrix for the random intercept
    \item \code{s2}: residual scale from the working LMM
    \item \code{iter}: number of iterations performed
    \item \code{SiXYZ_last}: last iteration's sufficient statistics (by site)
  }
}
\description{
Fits a generalized linear mixed model with site-level random intercepts using
only one-shot per-site summaries \code{(Ck, Sk, S2k, X0)}. Each of the
iterations constructs weighted LMM summary statistics which are then solved
by \code{lmm.fit} (from DLMM), yielding updated fixed effects and random
intercepts until convergence.
}
\details{
Uses canonical links: log for Poisson and logit for binomial. The fixed-effect
covariates in \code{X0} are assumed binary (plus optional \code{Intercept}).
For numerically extreme logits, a small weight floor is used internally.
Requires \code{lmm.fit} from \emph{dlmm.R} to be on the search path.
}
\examples{
# fit <- cola_glmm(summary_by_site, family = "poisson")
}
\keyword{internal}
