% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_cluster_bootstrap.R
\name{draw_cluster_bootstrap}
\alias{draw_cluster_bootstrap}
\title{Draw a cluster bootstrap sample from a data frame in long format}
\usage{
draw_cluster_bootstrap(df, idvar, boot.ids)
}
\arguments{
\item{df}{a data frame in long format}

\item{idvar}{name of the subject id in \code{df} (it should be a
numeric id that ranges from 1 to n, without skipping values)}

\item{boot.ids}{identifiers of the subjects to be sampled}
}
\value{
A data frame containing the bootstrapped observations
}
\description{
This function is part of the cluster bootstrap optimism correction
procedure described in Signorelli et al. (2021). Note 
that the function does not perform the random sampling, but it
extracts the correct records from a dataframe, given the ids of
the sampled clusters (subjects)
}
\references{
Signorelli, M. (2024). pencal: an R Package for the Dynamic 
Prediction of Survival with Many Longitudinal Predictors. 
The R Journal, 16 (2), 134-153.

Signorelli, M., Spitali, P., Al-Khalili Szigyarto, C, 
The MARK-MD Consortium, Tsonaka, R. (2021). 
Penalized regression calibration: a method for the prediction 
of survival outcomes using complex longitudinal and 
high-dimensional data. Statistics in Medicine, 40 (27), 6178-6196.
DOI: 10.1002/sim.9178
}
\author{
Mirko Signorelli
}
\keyword{internal}
